#ifndef __SLANG_H
#define __SLANG_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define word unsigned int
#define bool unsigned int   /* rather than char, for speed */

#define FLOAT double        /* Redefine here to change float-usage */

typedef struct __object {
    struct {
        word type: 7;
        word mark: 1;
    } header;
    union {
        long i;
        FLOAT f;
        struct {
            char *s;
            long hash;
        } strsym;
        struct {
            struct __object *car, *cdr;
        } cons;
        struct {
            struct __object *body, *env;
        } closure;
        struct {
            struct __object *(*proc)();
            char *name;
        } prim;
        struct {
            long length;
            struct __object **data;
        } vector;
        struct {
            long stack_len;
            char *jmp_stack;
        } cont;
        struct {
            char *name;
            FILE *file;
        } file;
    } d;
} _object, *OBJECT;

#define T_NULL          0
#define T_INT           1
#define T_FLOAT         2
#define T_STRING        3
#define T_SYM           4
#define T_CONS          5
#define T_CLOSURE       6
#define T_PRIM          7
#define T_FPRIM         8
#define T_MPRIM         9
#define T_VECTOR        10
#define T_CONTINUATION  11
#define T_FILE          12

#define T_FREELIST      127

#define TRUE            1
#define FALSE           0

#define LTYPE(x)        ((x)->header.type)
#define TYPE(x)         (NULLP(x)?T_NULL:LTYPE(x))
#define GCMARK(x)       ((x)->header.mark)
#define IDATA(x)        ((x)->d.i)
#define FDATA(x)        ((x)->d.f)
#define NDATA(x)        (INTP(x)?IDATA(x):FDATA(x))
#define SDATA(x)        ((x)->d.strsym.s)
#define HASH(x)         ((x)->d.strsym.hash)
#define CAR(x)          ((x)->d.cons.car)
#define CDR(x)          ((x)->d.cons.cdr)
#define BODY(x)         ((x)->d.closure.body)
#define ENV(x)          ((x)->d.closure.env)
#define PROC(x)         ((x)->d.prim.proc)
#define PNAME(x)        ((x)->d.prim.name)
#define VLEN(x)         ((x)->d.vector.length)
#define DATA(x)         ((x)->d.vector.data)
#define IDX(x,i)        (DATA(x)[i])
#define JMPPTR(x)       ((jmp_buf *)(x)->d.cont.jmp_stack)
#define JMP(x)          (*JMPPTR(x))
#define STACK(x)        ((OBJECT *)((x)->d.cont.jmp_stack + sizeof(jmp_buf)))
#define CLEN(x)         ((x)->d.cont.stack_len)
#define FNAME(x)        ((x)->d.file.name)
#define FHANDLE(x)      ((x)->d.file.file)

#define NULLP(x)        (x == NULL)
#define TYPEP(x,t)      (TYPE(x) == t)
#define INTP(x)         (TYPEP(x,T_INT))
#define FLOATP(x)       (TYPEP(x,T_FLOAT))
#define NUMP(x)         (INTP(x)||FLOATP(x))
#define STRINGP(x)      (TYPEP(x,T_STRING))
#define SYMP(x)         (TYPEP(x,T_SYM))
#define CONSP(x)        (TYPEP(x,T_CONS))
#define ATOMP(x)        (!CONSP(x))
#define LISTP(x)        (NULLP(x) || CONSP(x))
#define CLOSUREP(x)     (TYPEP(x,T_CLOSURE))
#define PRIMP(x)        (TYPEP(x,T_PRIM)||TYPEP(x,T_MPRIM)||TYPEP(x,T_FPRIM))
#define PROCP(x)        (PRIMP(x)||CLOSUREP(x))
#define VECTORP(x)      (TYPEP(x,T_VECTOR))
#define CONTP(x)        (TYPEP(x,T_CONTINUATION))
#define FILEP(x)        (TYPEP(x,T_FILE))

#define EQP(x,y)        ((x) == (y))
#define EOL             NULL
#define PRIVATE         static
#define S_BOOL(x)       ((x)?S_TRUE:S_FALSE)

/* In SLANG.C */

extern jmp_buf errjmp;
extern OBJECT errobj;
extern void error(char *message, OBJECT obj);
extern void fatal(char *message);
extern long list_length(OBJECT lst);
extern OBJECT copy_list(OBJECT lst);
extern void quit(void);
extern void init_slang(void (*repl_fun)(), void (*err_fun)(char *msg, OBJECT obj), bool want_init);

/* In MEMMAN.C */

extern void init_memman(void);
extern long cells_used;
extern long cells_free;
extern OBJECT newobj(void);
extern void *getmem(word size);

extern OBJECT *stack_start;
extern long gc_freed;
extern long gc_ticks;
extern void gc(void);

extern void call_cc(void);
extern void set_cc(void);

/* In OBJECT.C */

extern OBJECT cons(OBJECT car, OBJECT cdr);
extern OBJECT newint(long i);
extern OBJECT newfloat(FLOAT f);
extern OBJECT newstrobj(int type, char *s);
extern OBJECT newclosure(OBJECT body, OBJECT env);
extern OBJECT newprim(int type, OBJECT (*proc)(), char *name);
extern OBJECT newvector(long len);

/* In PRIM.C */

#define MAX_SPC_SYM 6
extern OBJECT spc_sym[];
#define UNDEFD          spc_sym[0]
#define S_TRUE          spc_sym[1]
#define S_FALSE         spc_sym[2]
#define EOF_VAL         spc_sym[3]
#define MARK            spc_sym[4]
#define F_STDIN         spc_sym[5]

extern void init_prim(void);

/* In SYMTAB.C */

#define streq_ss(a,b)   (!strcmp(a,b))
#define streq_os(a,b)   (!strcmp(SDATA(a),b))
extern bool streq_oo(OBJECT a, OBJECT b);

extern void init_symtab(void);
extern void addglobal(OBJECT sym, OBJECT val);
extern OBJECT getglbtab(void);

extern long hash_str(char *str);
extern OBJECT addframe(OBJECT env);
extern void defsym(OBJECT env, OBJECT sym, OBJECT val);
extern OBJECT refsym(OBJECT sym, OBJECT env, bool *found);
extern void setsym(OBJECT sym, OBJECT val, OBJECT env);

/* In INTERN.C */

extern OBJECT readobject(OBJECT f);

/* In STACK.C */

extern OBJECT getstk(void);
extern void setstk(OBJECT stk);
extern void push(OBJECT obj);
extern OBJECT pop(void);

/* In EVAL.C */

extern void set_alarm(FLOAT seconds, void (*handler)());
extern void check_alarm(void);
extern void disable_alarm(void);
extern void enable_alarm(void);

extern OBJECT m_apply(OBJECT proc, OBJECT *formptr, OBJECT *envptr);
extern void eval(OBJECT form, OBJECT env);

/* In IO.C */

extern OBJECT l_fopen(char *name, char *mode);
extern int l_getc(OBJECT file);
extern void l_ungetc(int c, OBJECT file);
extern bool l_feof(OBJECT file);

#endif
