#include "slang.h"
#define HASH_TABLE_SIZE 256

bool streq_oo(OBJECT a, OBJECT b) {
    if (HASH(a)==HASH(b))
        if (streq_ss(SDATA(a),SDATA(b)))
            return TRUE;
    return FALSE;
}

PRIVATE OBJECT symtab = EOL;

void init_symtab(void) {
    symtab = newvector(HASH_TABLE_SIZE);
}

PRIVATE OBJECT findglobalbinding(OBJECT sym) {
    long hash = HASH(sym) % HASH_TABLE_SIZE;
    OBJECT ent = IDX(symtab,hash);
    OBJECT thepair;
    while (!NULLP(ent)) {
        thepair = CAR(ent);
        if (streq_oo(CDR(thepair),sym)) return thepair;
        ent = CDR(ent);
    }
    return EOL;
}

void addglobal(OBJECT sym, OBJECT val) {
    long hash;
    OBJECT ent;

    ent = findglobalbinding(sym);
    if (!NULLP(ent)) {
        CAR(ent) = val;
        return;
    }

    hash = HASH(sym) % HASH_TABLE_SIZE;
    IDX(symtab,hash) = cons(cons(val,sym),IDX(symtab,hash));
}

OBJECT getglbtab(void) {
    return symtab;
}

long hash_str(char *str) {
    char *c;
    long hash = 0;
    for (c=str; *c; c++) hash = (hash + (hash << 3)) ^ (*c);
    return abs(hash);
}

OBJECT addframe(OBJECT env) {
    return cons(cons(EOL,EOL),env);
}

void defsym(OBJECT env, OBJECT sym, OBJECT val) {
    CAR(CAR(env)) = cons(sym,CAR(CAR(env)));
    CDR(CAR(env)) = cons(val,CDR(CAR(env)));
}

PRIVATE OBJECT findsymbinding(OBJECT sym, OBJECT env) {
    OBJECT frame = env;
    OBJECT syms;
    OBJECT vals;
    while (!NULLP(frame)) {
        syms = CAR(CAR(frame));
        vals = CDR(CAR(frame));
        while (CONSP(syms)) {
            if (streq_oo(CAR(syms),sym)) return vals;
            syms = CDR(syms);
            vals = CDR(vals);
        }
        frame = CDR(frame);
    }
    return EOL;
}

OBJECT refsym(OBJECT sym, OBJECT env, bool *found) {
    OBJECT s = findsymbinding(sym,env);

    if (NULLP(s)) s = findglobalbinding(sym);
    if (!NULLP(s)) {
        *found = TRUE;
        return CAR(s);
    }
    if (streq_os(sym,"errobj")) {
        *found = TRUE;
        return errobj;
    }
    if (streq_os(sym,"*current-env*")) {
        *found = TRUE;
        return cons(env,symtab);
    }
    *found = FALSE;
    return UNDEFD;
}

void setsym(OBJECT sym, OBJECT val, OBJECT env) {
    OBJECT s = findsymbinding(sym,env);

    if (NULLP(s)) s = findglobalbinding(sym);
    if (!NULLP(s)) {
        CAR(s) = val;
        return;
    }
    error("set: cannot find symbol to modify:",sym);
}
