static void CG_collect_typevec(C_word k, GType *v, guint n) {
  C_word space[C_SIZEOF_LIST(n) + C_SIZEOF_FLONUM * n];
  C_word *a = space;
  C_word acc = C_SCHEME_END_OF_LIST;
  int i;

  for (i = n - 1; i >= 0; i--) {
    C_word num = C_int_to_num(&a, v[i]);
    acc = C_pair(&a, num, acc);
  }

  g_free(v);

  C_kontinue(k, acc);
}

static void CG_gtype_children(C_word argc, C_word self, C_word k, C_word tp) {
  GType t = (GType) C_num_to_int(tp);
  guint n = 0;
  GType *v = g_type_children(t, &n);

  if (v == NULL) {
    C_kontinue(k, C_SCHEME_FALSE);
  } else {
    CG_collect_typevec(k, v, n);
  }
}

static void CG_gtype_interfaces(C_word argc, C_word self, C_word k, C_word tp) {
  GType t = (GType) C_num_to_int(tp);
  guint n = 0;
  GType *v = g_type_interfaces(t, &n);

  if (v == NULL) {
    C_kontinue(k, C_SCHEME_FALSE);
  } else {
    CG_collect_typevec(k, v, n);
  }
}

static void CG_collect_enum_info(C_word k, C_word acc, GEnumClass *eclass, int i) {
  if (i == -1) {
    g_type_class_unref(eclass);
    C_kontinue(k, acc);
  } else {
    GEnumValue *v = &(eclass->values[i]);
    C_word aa[C_SIZEOF_LIST(3) + C_SIZEOF_PAIR +
	      C_SIZEOF_STRING(strlen(v->value_name)) +
	      C_SIZEOF_INTERNED_SYMBOL(strlen(v->value_nick))];
    C_word *a = aa;
    C_word na = C_string2(&a, v->value_name);
    C_word ni = C_intern2(&a, v->value_nick);
    C_word elt = C_list(&a, 3, ni, na, C_fix(v->value));
    CG_collect_enum_info(k, C_pair(&a, elt, acc), eclass, i - 1);
  }
}

static void CG_genum_info(C_word argc, C_word self, C_word k, C_word tp) {
  GType t = (GType) C_num_to_int(tp);

  if (!G_TYPE_IS_ENUM(t)) {
    C_kontinue(k, C_SCHEME_FALSE);
  } else {
    GEnumClass *eclass = G_ENUM_CLASS(g_type_class_ref(t));
    CG_collect_enum_info(k, C_SCHEME_END_OF_LIST, eclass, eclass->n_values - 1);
  }
}

static void CG_collect_flags_info(C_word k, C_word acc, GFlagsClass *fclass, int i) {
  if (i == -1) {
    g_type_class_unref(fclass);
    C_kontinue(k, acc);
  } else {
    GFlagsValue *v = &(fclass->values[i]);
    C_word aa[C_SIZEOF_LIST(3) + C_SIZEOF_PAIR +
	      C_SIZEOF_FLONUM +
	      C_SIZEOF_STRING(strlen(v->value_name)) +
	      C_SIZEOF_INTERNED_SYMBOL(strlen(v->value_nick))];
    C_word *a = aa;
    C_word vv = C_int_to_num(&a, v->value);
    C_word na = C_string2(&a, v->value_name);
    C_word ni = C_intern2(&a, v->value_nick);
    C_word elt = C_list(&a, 3, ni, na, vv);
    CG_collect_flags_info(k, C_pair(&a, elt, acc), fclass, i - 1);
  }
}

static void CG_gflags_info(C_word argc, C_word self, C_word k, C_word tp) {
  GType t = (GType) C_num_to_int(tp);

  if (!G_TYPE_IS_FLAGS(t)) {
    C_kontinue(k, C_SCHEME_FALSE);
  } else {
    GFlagsClass *fclass = G_FLAGS_CLASS(g_type_class_ref(t));
    CG_collect_flags_info(k, C_SCHEME_END_OF_LIST, fclass, fclass->n_values - 1);
  }
}

/**
 * GValue/Object interconversion based on pyg_value_as_pyobject and
 * pyg_value_from_pyobject, from pygtype.c, from the pygtk module of
 * the GNOME Project.
 **/

#define CHK_NUMBER(vvv)								\
  do {										\
    if (C_i_numberp(vvv) == C_SCHEME_FALSE) {					\
      g_warning("CG_fill_gvalue: fundamental type %s: CHK_NUMBER failed",	\
		g_type_name(G_TYPE_FUNDAMENTAL(value_type)));			\
      C_kontinue(k, C_SCHEME_FALSE);						\
    }										\
  } while(0)

#define CHK_NONIMM(ppp, vvv)									\
  do {												\
    if (C_immediatep(vvv) || (ppp(vvv) == C_SCHEME_FALSE)) {					\
      g_warning("CG_fill_gvalue: fundamental type %s: CHK_NONIMM failed; predicate " #ppp,	\
		g_type_name(G_TYPE_FUNDAMENTAL(value_type)));					\
      C_kontinue(k, C_SCHEME_FALSE);								\
    }												\
  } while(0)

static void CG_fill_gvalue(C_word argc, C_word self, C_word k, C_word v, C_word o) {
  GValue *value;
  GType value_type;

  if (argc != 4) C_bad_argc(argc, 4);

  value = (GValue *) C_pointer_address(v);
  value_type = G_VALUE_TYPE(value);

  switch (G_TYPE_FUNDAMENTAL(value_type)) {
    case G_TYPE_INTERFACE:
      C_kontinue(k, C_SCHEME_FALSE);

    case G_TYPE_CHAR:
      if (!C_charp(o)) {
	g_warning("CG_fill_gvalue: G_TYPE_CHAR: expected char");
	C_kontinue(k, C_SCHEME_FALSE);
      }
      g_value_set_char(value, C_character_code(o));
      break;

    case G_TYPE_UCHAR:
      if (!C_charp(o)) {
	g_warning("CG_fill_gvalue: G_TYPE_UCHAR: expected char");
	C_kontinue(k, C_SCHEME_FALSE);
      }
      g_value_set_uchar(value, C_character_code(o));
      break;

    case G_TYPE_BOOLEAN:
      g_value_set_boolean(value, C_SCHEME_FALSE != o);
      break;

    case G_TYPE_INT:
      CHK_NUMBER(o);
      g_value_set_int(value, C_num_to_int(o));
      break;

    case G_TYPE_UINT:
      CHK_NUMBER(o);
      g_value_set_uint(value, C_num_to_unsigned_int(o));
      break;

    case G_TYPE_LONG:
      CHK_NUMBER(o);
      g_value_set_long(value, C_num_to_long(o));
      break;

    case G_TYPE_ULONG:
      CHK_NUMBER(o);
      g_value_set_ulong(value, C_num_to_unsigned_long(o));
      break;

    case G_TYPE_INT64:
      CHK_NONIMM(C_flonump, o);
      g_value_set_int64(value, (gint64) C_flonum_magnitude(o));
      break;

    case G_TYPE_UINT64:
      CHK_NONIMM(C_flonump, o);
      g_value_set_uint64(value, (guint64) C_flonum_magnitude(o));
      break;

    case G_TYPE_ENUM: {
      CHK_NONIMM(C_symbolp, o);

      {
	GEnumClass *eclass = G_ENUM_CLASS(g_type_class_ref(value_type));
	C_word nickobj = C_block_item(o, 1);	/* symbol's name */
	int nicklen = C_header_size(nickobj);
	char nick[nicklen + 1];
	GEnumValue *v;

	memcpy(nick, C_c_string(nickobj), nicklen);
	nick[nicklen] = '\0';
	v = g_enum_get_value_by_nick(eclass, nick);

	if (v != NULL) {
	  g_value_set_enum(value, v->value);
	  g_type_class_unref(eclass);
	} else {
	  g_type_class_unref(eclass);
	  C_kontinue(k, C_SCHEME_FALSE);
	}
      }
      break;
    }

    case G_TYPE_FLAGS: {
      CHK_NUMBER(o);
      g_value_set_flags(value, C_num_to_unsigned_int(o));
      break;
    }

    case G_TYPE_FLOAT: {
      CHK_NONIMM(C_flonump, o);
      g_value_set_float(value, (guint64) C_flonum_magnitude(o));
      break;
    }

    case G_TYPE_DOUBLE: {
      CHK_NONIMM(C_flonump, o);
      g_value_set_double(value, (guint64) C_flonum_magnitude(o));
      break;
    }

    case G_TYPE_STRING: {
      CHK_NONIMM(C_stringp, o);
      {
	int len = C_header_size(o);
	char buffer[len + 1];
	memcpy(buffer, C_c_string(o), len);
	buffer[len] = '\0';
	g_value_set_string(value, buffer);
	break;
      }
    }

    case G_TYPE_POINTER: {
      CHK_NONIMM(C_pointerp, o);
      g_value_set_pointer(value, C_pointer_address(o));
      break;
    }

    case G_TYPE_BOXED: {
      C_word p;
      CHK_NONIMM(C_structurep, o);
      if (C_header_size(o) != 3) C_kontinue(k, C_SCHEME_FALSE);
      p = C_block_item(o, 2);
      CHK_NONIMM(C_pointerp, p);
      g_value_set_boxed(value, C_pointer_address(p));
      break;
    }

    case G_TYPE_PARAM:
      C_kontinue(k, C_SCHEME_FALSE);

    case G_TYPE_OBJECT: {
      C_word p;
      GObject *obj;
      CHK_NONIMM(C_structurep, o);
      if (C_header_size(o) != 2) C_kontinue(k, C_SCHEME_FALSE);
      p = C_block_item(o, 1);
      CHK_NONIMM(C_pointerp, p);
      obj = (GObject *) C_pointer_address(p);
      if (!G_TYPE_CHECK_INSTANCE_TYPE(obj, value_type)) C_kontinue(k, C_SCHEME_FALSE);
      g_value_set_object(value, obj);
      break;
    }

    default:
      C_kontinue(k, C_SCHEME_FALSE);
  }

  C_kontinue(k, C_SCHEME_TRUE);
}

static void CG_collect_properties(C_word k,
				  C_word acc,
				  GObjectClass *oclass,
				  GParamSpec **props,
				  guint remaining)
{
  if (remaining == 0) {
    g_free(props);
    g_type_class_unref(oclass);
    C_kontinue(k, acc);
  } else {
    int i = remaining - 1;
    GParamSpec *p = props[i];

    char const *pname = g_param_spec_get_name(p);

    C_word space[C_SIZEOF_LIST(3) +
		 C_SIZEOF_STRING(strlen(pname)) +
		 C_SIZEOF_FLONUM +
		 C_SIZEOF_PAIR];
    C_word *a = space;

    C_word na = C_string2(&a, (char *) pname);
    C_word tt = C_int_to_num(&a, p->value_type);
    int fl =
      ((p->flags & G_PARAM_READABLE)		? 1 : 0) |
      ((p->flags & G_PARAM_WRITABLE)		? 2 : 0) |
      ((p->flags & G_PARAM_CONSTRUCT_ONLY)	? 4 : 0);

    C_word l = C_list(&a, 3, na, tt, C_fix(fl));

    CG_collect_properties(k, C_pair(&a, l, acc), oclass, props, remaining - 1);
  }
}

static void CG_object_list_properties(C_word argc, C_word self, C_word k, C_word tp) {
  GType t = (GType) C_num_to_int(tp);

  if (!G_TYPE_IS_OBJECT(t)) {
    C_kontinue(k, C_SCHEME_FALSE);
  } else {
    GObjectClass *oclass = g_type_class_ref(t);
    guint nprops = 0;
    GParamSpec **props = g_object_class_list_properties(oclass, &nprops);
    CG_collect_properties(k, C_SCHEME_END_OF_LIST, oclass, props, nprops);
  }
}

static void CG_object_find_property(C_word argc, C_word self, C_word k, C_word tp, C_word pn) {
  GType t = (GType) C_num_to_int(tp);
  GObjectClass *oclass = g_type_class_ref(t);
  int len = C_header_size(pn);
  char buf[len + 1];

  memcpy(buf, C_c_string(pn), len);
  buf[len] = '\0';

  {
    GParamSpec *p = g_object_class_find_property(oclass, buf);

    if (p == NULL) {
      C_kontinue(k, C_SCHEME_FALSE);
    } else {
      char const *pname = g_param_spec_get_name(p);

      C_word space[C_SIZEOF_LIST(3) +
		   C_SIZEOF_STRING(strlen(pname)) +
		   C_SIZEOF_FLONUM];
      C_word *a = space;

      C_word na = C_string2(&a, (char *) pname);
      C_word tt = C_int_to_num(&a, p->value_type);
      int fl =
	((p->flags & G_PARAM_READABLE)		? 1 : 0) |
	((p->flags & G_PARAM_WRITABLE)		? 2 : 0) |
	((p->flags & G_PARAM_CONSTRUCT_ONLY)	? 4 : 0);

      C_word l = C_list(&a, 3, na, tt, C_fix(fl));

      C_kontinue(k, l);
    }
  }
}
