;;@title "GTK+ 2.0 binding"
(declare
 (usual-integrations)
 (foreign-declare #<<EOF

#include <gtk/gtk.h>

static void CG_collect_stringlist(C_word k, GSList *head, GSList *curr, C_word acc) {
   if (curr == NULL) {
     g_slist_free(head);
     C_kontinue(k, acc);
   } else {
     int len = strlen((gchar const *) curr->data);
     C_word space[C_SIZEOF_PAIR + C_SIZEOF_STRING(len)];
     C_word *a = space;
     C_word s = C_string(&a, len, (gchar *) curr->data);
     g_free(curr->data);
     CG_collect_stringlist(k, head, curr->next, C_pair(&a, s, acc));
   }
}

static void CG_stock_list_ids(C_word argc, C_word self, C_word k) {
   GSList *l = gtk_stock_list_ids();
   CG_collect_stringlist(k, l, l, C_SCHEME_END_OF_LIST);
}

EOF
))

;;@ <synopsis>(require 'gtk)</synopsis>
;; The gtk extension module provides a wrapping for the GTK+ GUI
;; toolkit library, version 2.0. It depends upon the gobject
;; extension.

;---------------------------------------------------------------------------;
;;@section "General"

;;@ Most of the functions supported by the GTK+ binding extension are
;; automatically generated from <filename>*.defs</filename> files,
;; taken from James Henstridge's <application>pygtk</application> GTK+
;; binding for Python.
;;
;; The generated code is contained in internal modules which don't
;; need to be <function>require</function>d separately - they're
;; automatically included when the gtk module is loaded. Some of the
;; generated code is not a good fit for Chicken, so it has been
;; overridden by hand-written code<footnote><para>Isn't it nice having
;; procedures in mutable global variables?</para></footnote> in the
;; gtk module itself.
;;
;; Generated procedures usually have a name derived from the name of
;; the C function they are wrapping: case is folded to lowercase, and
;; underscores are replaced with hyphens, so for instance
;; <literal>gtk_main_quit</literal> becomes
;; <literal>gtk-main-quit</literal>.
;;
;; Methods on wrapped <classname>GtkObject</classname> subclasses are
;; registered with the introspection facilities of the gobject module
;; with calls to <function>gobject:register-method!</function>.

(require 'gobject)
(require-for-syntax 'gobject)

(require 'srfi-4)

((foreign-lambda* void ()
		  "int argc = 1;"
		  "char *argv[] = { \"gtkchicken\" , NULL };"
		  "char **argv_p = &argv[0];"
		  "gtk_init(&argc, &argv_p);"))

(gtype:init-types-from-file "gdk-types")
(gtype:init-types-from-file "gtk-types")

;;@function (gtk-signal-connect object signal-name handler-fn)
;;An alias for <function>gsignal-connect</function>.
(define gtk-signal-connect gsignal-connect)

(require '(gtk wrap-boxed))
(require '(gtk wrap-classes))
(require '(gtk wrap-enum))
(require '(gtk wrap-flags))
(require '(gtk wrap-functions))

(require '(gtk gdkevent))

;; Override entry points to allow callbacks.

;;@function (gtk-main)
;;Pass control to the GTK+ main loop. This call does not return until
;;the application indicates it is ready to terminate by calling
;;<function>gtk-main-quit</function>.
(define gtk-main
  (foreign-callback-lambda void "gtk_main"))

;;@function (gtk-main-iteration)
;;Delegates directly to the C function
;;<function>gtk_main_iteration</function>.
(define gtk-main-iteration
  (foreign-callback-lambda bool "gtk_main_iteration"))

;---------------------------------------------------------------------------;
;;@section "Timeouts, idle-handlers, and input-handlers"
;;Input handlers are not currently supported.

(define-record gtk:gtkfunction number kind thunk)

(define gtk:gtkfunctions-freelist '())
(define gtk:next-gtkfunction 1)
(define gtk:gtkfunctions (make-hash-table =))
(define gtk:timeout-handlers (make-hash-table =))
(define gtk:idle-handlers (make-hash-table =))

(define (gtk:reserve-function-number)
  (if (null? gtk:gtkfunctions-freelist)
      (let ((n gtk:next-gtkfunction))
	(set! gtk:next-gtkfunction (+ n 1))
	n)
      (let ((n gtk:gtkfunctions-freelist))
	(set! gtk:gtkfunctions-freelist (cdr n))
	(car n))))

(define (gtk:release-function-number n)
  (set! gtk:gtkfunctions-freelist (cons n gtk:gtkfunctions-freelist)))

(define-external (cg_gtk_function (c-pointer data))
  bool
  (let* ((n (gobject:gpointer-to-uint data))
	 (f (hash-table-ref gtk:gtkfunctions n)))
    (if f
	((gtk:gtkfunction-thunk f))
	(begin
	  (g-warning "cg_gtk_function: unknown callback number: " n)
	  #f))))

(define-record gtk:timeout-handle number)
(define-record-printer (gtk:timeout-handle h out)
  (for-each (lambda (x) (display x out))
	    (list "#<gtk:timeout-handle " (gtk:timeout-handle-number h) ">")))

;;@ Installs a timeout-handling procedure. After
;;<parameter>interval</parameter> milliseconds, and every
;;<parameter>interval</parameter> thereafter,
;;<parameter>thunk</parameter> will be called with no arguments. If
;;<parameter>thunk</parameter> returns <literal>#f</literal>, the
;;timeout-handler will not run again (it will be removed). The
;;semantics are derived from the underlying C procedure,
;;<function>gtk_timeout_add</function>. This function returns a
;;<structname>gtk:timeout-handle</structname> record, which can be
;;passed in to <function>gtk-timeout-remove</function>.
(define (gtk-timeout-add interval thunk)
  (let* ((n (gtk:reserve-function-number))
	 (f (make-gtk:gtkfunction n 'timeout thunk)))
    (hash-table-set! gtk:gtkfunctions n f)
    (let ((h ((foreign-lambda* unsigned-integer ((unsigned-integer interval)
						 (unsigned-integer data))
			       "return(gtk_timeout_add(interval, (GtkFunction) cg_gtk_function,"
			       "                       GUINT_TO_POINTER(data)));")
	      interval
	      n)))
      (hash-table-set! gtk:timeout-handlers h f)
      (make-gtk:timeout-handle h))))

;;@ Removes a previously-registered timeout handler, using a
;;<structname>gtk:timeout-handle</structname> record returned by
;;<function>gtk-timeout-add</function>.
(define (gtk-timeout-remove handle)
  (let* ((h (gtk:timeout-handle-number handle))
	 (f (hash-table-ref gtk:timeout-handlers h)))
    (if (not f)
	(error "gtk-timeout-remove: not found" handle)
	(begin
	  (assert (eq? 'timeout (gtk:gtkfunction-kind f)))
	  ((foreign-lambda void "gtk_timeout_remove" unsigned-integer) h)
	  (hash-table-remove! gtk:timeout-handlers h)
	  (hash-table-remove! gtk:gtkfunctions (gtk:gtkfunction-number f))
	  (gtk:release-function-number (gtk:gtkfunction-number f))))))

(define-record gtk:idle-handle number)
(define-record-printer (gtk:idle-handle h out)
  (for-each (lambda (x) (display x out))
	    (list "#<gtk:idle-handle " (gtk:idle-handle-number h) ">")))

;;@ Installs <parameter>thunk</parameter> as a GTK+ idle handler, as
;;per the C function <function>gtk_idle_add</function>. Returns a
;;<structname>gtk:idle-handle</structname> record, which may be used
;;with <function>gtk-idle-remove</function>.
(define (gtk-idle-add thunk)
  (let* ((n (gtk:reserve-function-number))
	 (f (make-gtk:gtkfunction n 'idle thunk)))
    (hash-table-set! gtk:gtkfunctions n f)
    (let ((h ((foreign-lambda* unsigned-integer ((unsigned-integer data))
			       "return(gtk_idle_add((GtkFunction) cg_gtk_function,"
			       "                    GUINT_TO_POINTER(data)));")
	      n)))
      (hash-table-set! gtk:idle-handlers h f)
      (make-gtk:idle-handle h))))

;;@ Removes a previously installed GTK+ idle handler, using the
;;<structname>gtk:idle-handle</structname> record returned from
;;<function>gtk-idle-add</function>.
(define (gtk-idle-remove handle)
  (let* ((h (gtk:idle-handle-number handle))
	 (f (hash-table-ref gtk:idle-handlers h)))
    (if (not f)
	(error "gtk-idle-remove: not found" handle)
	(begin
	  (assert (eq? 'idle (gtk:gtkfunction-kind f)))
	  ((foreign-lambda void "gtk_idle_remove" unsigned-integer) h)
	  (hash-table-remove! gtk:idle-handlers h)
	  (hash-table-remove! gtk:gtkfunctions (gtk:gtkfunction-number f))
	  (gtk:release-function-number (gtk:gtkfunction-number f))))))

;---------------------------------------------------------------------------;
;;@section "GDK"

;;@ Return a list (R G B) of the three colour components contained in
;;a <structname>GdkColor</structname> structure.
(define gdk-color->list
  (let ((color-r (foreign-lambda* int (((pointer "GdkColor") c)) "return(c->red);"))
	(color-g (foreign-lambda* int (((pointer "GdkColor") c)) "return(c->green);"))
	(color-b (foreign-lambda* int (((pointer "GdkColor") c)) "return(c->blue);")))
    (lambda (c)
      (let ((p (gboxed-pointer c)))
	(list (color-r p)
	      (color-g p)
	      (color-b p))))))

(gobject:register-method! "GdkColor"
			  '->list
			  'gdk-color->list
			  gdk-color->list)

;;@ Convert a list (R G B) into a <structname>GdkColor</structname>
;;boxed object.
(define list->gdk-color
  (let ((t (gtype-from-name "GdkColor")))
    (lambda (l)
      (wrap-gboxed t
		   (apply (foreign-lambda* c-pointer ((int r) (int g) (int b))
					   "GdkColor c;"
					   "c.red = r;"
					   "c.green = g;"
					   "c.blue = b;"
					   "return(gdk_color_copy(&c));")
			  l)
		   #f))))

;;@ Extract the pixel value from a <structname>GdkColor</structname>
;;structure.
(define gdk-color-pixel
  (let ((color-p (foreign-lambda* int (((pointer "GdkColor") c)) "return(c->pixel);")))
    (lambda (c)
      (color-p (gboxed-pointer c)))))

(gobject:register-method! "GdkColor"
			  'pixel
			  'gdk-color-pixel
			  gdk-color-pixel)

;;@ Update the pixel value within a <structname>GdkColor</structname>
;;structure.
(define gdk-color-pixel-set!
  (let ((color-p (foreign-lambda* void (((pointer "GdkColor") c)
					(int p))
				  "c->pixel = p;")))
    (lambda (color newpixel)
      (color-p (gboxed-pointer color) newpixel)
      newpixel)))

(gobject:register-method! "GdkColor"
			  'pixel
			  'gdk-color-pixel-set!
			  gdk-color-pixel-set!)

;;@ Convert a <structname>GdkRectangle</structname> into a list (x y
;;width height).
(define gdk-rectangle->list
  (let ((gx (foreign-lambda* integer (((pointer "GdkRectangle") p)) "return(p->x);"))
	(gy (foreign-lambda* integer (((pointer "GdkRectangle") p)) "return(p->y);"))
	(gw (foreign-lambda* integer (((pointer "GdkRectangle") p)) "return(p->width);"))
	(gh (foreign-lambda* integer (((pointer "GdkRectangle") p)) "return(p->height);")))
    (lambda (r)
      (let ((p (gboxed-pointer r)))
	(list (gx p)
	      (gy p)
	      (gw p)
	      (gh p))))))

(gobject:register-method! "GdkRectangle"
			  '->list
			  'gdk-rectangle->list
			  gdk-rectangle->list)

;;@ Convert a list (x y width height) into a
;;<structname>GdkRectangle</structname> boxed object.
(define list->gdk-rectangle
  (let ((t (gtype-from-name "GdkRectangle")))
    (lambda (l)
      (wrap-gboxed t
		   (apply (foreign-lambda* c-pointer ((integer x) (integer y)
						      (integer w) (integer h))
					   "static GType r_t = 0;"
					   "GdkRectangle r;"
					   "if (r_t == 0)"
					   "  r_t = g_type_from_name(\"GdkRectangle\");"
					   "r.x = x;"
					   "r.y = y;"
					   "r.width = w;"
					   "r.height = h;"
					   "return(g_boxed_copy(r_t, &r));")
			  l)
		   #f))))

;;@ Returns multiple values: (x y state), where x and y make up the
;;current pointer coordinate, and state is a list of GdkModifierType
;;symbols.
(define (gdk-window-get-pointer w)
  (let ((v (make-s32vector 3)))
    ((foreign-lambda* void (((pointer "GdkWindow") w)
			    (s32vector v))
		      "int x, y;"
		      "GdkModifierType state;"
		      "gdk_window_get_pointer(w, &x, &y, &state);"
		      "v[0] = x;"
		      "v[1] = y;"
		      "v[2] = (int) state;")
     (g:unbox-GdkWindow w)
     v)
    (values (s32vector-ref v 0)
	    (s32vector-ref v 1)
	    (number->GdkModifierType (s32vector-ref v 2)))))

(gobject:register-method! "GdkWindow"
			  'get-pointer
			  'gdk-window-get-pointer
			  gdk-window-get-pointer)

;---------------------------------------------------------------------------;
; Fill in some missing methods, and override some inappropriately-wrapped methods.
;;@section "Miscellaneous and overridden procedures"

;;@function (gtk:gc-idle-timeout (#:optional value))
;; If <parameter>value</parameter> is omitted, returns the current
;; setting for the number of milliseconds of GTK idleness before a GC
;; is forced; otherwise, sets the setting to the passed-in number of
;; milliseconds. Only used when <function>gtk:gc-when-idle</function>
;; has been enabled. Defaults to 1000 milliseconds.
(define gtk:gc-idle-timeout (make-parameter 1000))

;;@function (gtk:gc-when-idle (#:optional value))
;; If <parameter>value</parameter> is omitted, returns
;; <literal>#t</literal> if the GTK-idle-garbage-collector is enabled,
;; or <literal>#f</literal> otherwise. If <parameter>value</parameter>
;; is specified, enables the idle-garbage-collector unless
;; <parameter>value</parameter> is <literal>#f</literal>. Defaults to
;; being switched off.
(define gtk:gc-when-idle
  (let ((id #f)
	(gc-idler (lambda ()
		    (let loop ((collected #f))
		      (when (zero? (gtk-events-pending))
			(if collected
			    (begin
			      (gtk-main-iteration)
			      (loop #f))
			    (let* ((gc-ran #f)
				   (id (gtk-timeout-add
					(gtk:gc-idle-timeout)
					(lambda ()
;					    (print* "(gc...") (flush-output) (time
					  (gc #t)
;					     ) (print "done)")
					  (set! gc-ran #t)
					  #f))))
			      (gtk-main-iteration)
			      (gtk-timeout-remove id)
			      (loop gc-ran))))))))
    (lambda arg
      (if (pair? arg)
	  (if (car arg)
	      (if id
		  #f
		  (begin
		    (set! id (gtk-idle-add gc-idler))
		    #t))
	      (if id
		  (begin
		    (gtk-idle-remove id)
		    (set! id #f)
		    #t)
		  #f))
	  (if id #t #f)))))

;;@ Retrieve the date selected by a <classname>GtkCalendar</classname>
;;widget, in the form of a list of three numbers, year, month, day:
;;<literal>(2002 10 13)</literal>.
(define (gtk-calendar-get-date cal)
  (u32vector->list
   (let ((u (make-u32vector 3)))
     ((foreign-lambda* void ((c-pointer cal)
			     (u32vector u))
		       "gtk_calendar_get_date(cal, &u[0], &u[1], &u[2]);")
      (g:unbox-GtkCalendar cal)
      u)
     u)))

;;@function (gtk-stock-list-ids)
;;Returns a list of all current GTK+ <quote>stock ID</quote> strings.
(define gtk-stock-list-ids (##core#primitive "CG_stock_list_ids"))

;;@ Allocates a new instance of <classname>GtkTreeIter</classname>,
;;for use with various GTK+ tree model and view functions.
(define gtk-tree-iter-new
  (let ((t (gtype-from-name "GtkTreeIter")))
    (lambda ()
      (wrap-gboxed t
		   ((foreign-lambda* c-pointer ()
				     "GtkTreeIter *r = g_new0(GtkTreeIter, 1);"
				     "return(r);"))
		   #f))))

;;@ Creates and returns a new instance of
;;<classname>GtkListStore</classname> with the same number of columns
;;as parameters to the function call. Each parameter should be a
;;<structname>gtype</structname> record (as returned by
;;<function>gtype-from-name</function>, for example, or as stored in
;;variables such as <varname>gtype:string</varname> or
;;<varname>gtype:boolean</varname>).
(define (gtk-list-store-new . coltypes)
  (let ((ctvec (list->u32vector (map gtype-number coltypes))))
    (wrap-gobject
     ((foreign-lambda* c-pointer ((integer n)
				  (u32vector v))
		       "return(gtk_list_store_newv(n, (GType*) v));")
      (u32vector-length ctvec)
      ctvec))))

;;@ Creates and returns a new instance of
;;<classname>GtkTreeStore</classname> with the same number of columns
;;as parameters to the function call. Each parameter should be a
;;<structname>gtype</structname> record, as for
;;<function>gtk-list-store-new</function>.
(define (gtk-tree-store-new . coltypes)
  (let ((ctvec (list->u32vector (map gtype-number coltypes))))
    (wrap-gobject
     ((foreign-lambda* c-pointer ((integer n)
				  (u32vector v))
		       "return(gtk_tree_store_newv(n, (GType*) v));")
      (u32vector-length ctvec)
      ctvec))))

;;@ Sets the number and type of columns associated with the
;;<classname>GtkListStore</classname>
;;<parameter>l</parameter>. <parameter>coltypes</parameter> are as for
;;<function>gtk-list-store-new</function>.
(define (gtk-list-store-set-column-types l . coltypes)
  (let ((ctvec (list->u32vector (map gtype-number coltypes))))
    ((foreign-lambda* void ((c-pointer l)
			    (integer n)
			    (u32vector v))
		      "gtk_list_store_set_column_types(GTK_LIST_STORE(l), n, (GType*) v);")
     (gobject-pointer l)
     (u32vector-length ctvec)
     ctvec)))

;;@ Sets the number and type of columns associated with the
;;<classname>GtkTreeStore</classname>
;;<parameter>t</parameter>. <parameter>coltypes</parameter> are as for
;;<function>gtk-tree-store-new</function>.
(define (gtk-tree-store-set-column-types t . coltypes)
  (let ((ctvec (list->u32vector (map gtype-number coltypes))))
    ((foreign-lambda* void ((c-pointer t)
			    (integer n)
			    (u32vector v))
		      "gtk_tree_store_set_column_types(GTK_TREE_STORE(t), n, (GType*) v);")
     (gobject-pointer t)
     (u32vector-length ctvec)
     ctvec)))

;;@ Stores the currently-selected row of the
;;<classname>GtkTreeSelection</classname> <parameter>sel</parameter>
;;(single-row-selection mode only) into the
;;<classname>GtkTreeIter</classname> <parameter>iter</parameter>. If
;;there is no current selection, <literal>#f</literal> is returned;
;;otherwise, the associated <classname>GtkTreeModel</classname> is
;;returned.
(define (gtk-tree-selection-get-selected sel iter)
  (wrap-gobject
   ((foreign-lambda* c-pointer ((c-pointer sel)
				(c-pointer iter))
		     "GtkTreeModel *model = NULL;"
		     "gboolean result = gtk_tree_selection_get_selected((GtkTreeSelection*)sel,"
		     "                                                  &model,"
		     "                                                  (GtkTreeIter*)iter);"
		     "return(result ? model : NULL);")
    (gobject-pointer sel)
    (gboxed-pointer iter))))

;;@ Extracts the <structfield>window</structfield> field of the
;;<structname>GtkWidget</structname> struct associated with the
;;passed-in object.
(define gtk-widget-window
  (let ((ww (foreign-lambda* c-pointer (((pointer "GtkWidget") w))
			     "return(w->window);")))
    (lambda (w)
      (wrap-gobject (ww (gobject-pointer w))))))

(gobject:register-method! "GtkWidget"
			  'window
			  'gtk-widget-window
			  gtk-widget-window)

;;@ Extracts the <structfield>allocation</structfield> field of the
;;<structname>GtkWidget</structname> struct associated with the
;;passed-in object.
(define gtk-widget-allocation
  (let ((wa (foreign-lambda* c-pointer (((pointer "GtkWidget") w))
			     "return(&(w->allocation));")))
    (lambda (w)
      (g:box-GdkRectangle (wa (gobject-pointer w))))))

(gobject:register-method! "GtkWidget"
			  'allocation
			  'gtk-widget-allocation
			  gtk-widget-allocation)

;;@ Extracts the <structfield>state</structfield> field of the
;;<structname>GtkWidget</structname> struct associated with the
;;passed-in object, and returns it in symbolic form.
(define (gtk-widget-get-state w)
  (number->GtkStateType
   ((foreign-lambda int "GTK_WIDGET_STATE" (pointer "GtkWidget"))
    (gobject-pointer w))))

(gobject:register-method! "GtkWidget"
			  'get-state
			  'gtk-widget-get-state
			  gtk-widget-get-state)

;;@ Retrieves the black GC from the passed-in style.
(define (gtk-style-black-gc style)
  (assert (GtkStyle? style))
  (g:box-GdkGC
   ((foreign-lambda* c-pointer (((pointer "GtkStyle") style))
		     "return(style->black_gc);")
    (gobject-pointer style))))

(gobject:register-method! "GtkStyle"
			  'black-gc
			  'gtk-style-black-gc
			  gtk-style-black-gc)

;;@ Retrieves the white GC from the passed-in style.
(define (gtk-style-white-gc style)
  (assert (GtkStyle? style))
  (g:box-GdkGC
   ((foreign-lambda* c-pointer (((pointer "GtkStyle") style))
		     "return(style->white_gc);")
    (gobject-pointer style))))

(gobject:register-method! "GtkStyle"
			  'white-gc
			  'gtk-style-white-gc
			  gtk-style-white-gc)

;;@ Retrieves the foreground GC from the passed-in style that is
;;appropriate to the passed-in GtkStateType symbol.
(define (gtk-style-fg-gc style state)
  (assert (GtkStyle? style))
  (g:box-GdkGC
   ((foreign-lambda* c-pointer (((pointer "GtkStyle") style)
				(int state))
		     "return(style->fg_gc[state]);")
    (gobject-pointer style)
    (GtkStateType->number state))))

(gobject:register-method! "GtkStyle"
			  'fg-gc
			  'gtk-style-fg-gc
			  gtk-style-fg-gc)

;;@ Inserts text <parameter>string</parameter> at the
;;<parameter>position</parameter> passed in. Returns the new insertion
;;position after the insert operation.
(define (gtk-editable-insert-text editable string position)
  ((foreign-lambda* integer (((pointer "GtkEditable") e)
			     (byte-vector bv)
			     (unsigned-integer len)
			     (integer in_pos))
		    "gint pos = in_pos;"
		    "gtk_editable_insert_text(e, (gchar const *) bv, len, &pos);"
		    "return(pos);")
   (g:unbox-GtkEditable editable)
   (if (string? string)
       (string->byte-vector string)
       string)
   (if (string? string)
       (string-length string)
       (byte-vector-length string))
   position))
