;;@title "Libglade 2.0 binding"
(declare
 (usual-integrations)

 (foreign-declare #<<EOF

#include <glade/glade.h>

EOF
))

;;@ <synopsis>(require 'libglade)</synopsis>
;; The libglade extension module provides a wrapping for James
;; Henstridge's Libglade library, version 2.0. It depends upon the
;; gobject and gtk extensions.

(require 'gtk)

((foreign-lambda* void ()
		  "glade_init();"
		  "glade_xml_get_type();"))

;;@function (glade-xml-new filename (#:domain domain) (#:root root))
;; Reads the Glade XML file <parameter>filename</parameter>,
;; constructing the widget tree. The optional keyword arguments
;; <parameter>domain</parameter> and <parameter>root</parameter> are
;; passed through to the underlying C function,
;; <function>glade_xml_new</function>; if they are omitted,
;; <literal>NULL</literal> is passed in their place.
(define (glade-xml-new filename . rest)
  (let ((domain (get-keyword #:domain rest))
	(root (get-keyword #:root rest)))
    (wrap-gobject ((foreign-lambda c-pointer "glade_xml_new"
				   c-string c-string c-string)
		   filename
		   root
		   domain))))

;;@function (glade-xml-new-from-memory bv-or-string (#:domain domain) (#:root root))
;; As for <function>glade-xml-new</function>, except instead of
;; reading XML from a file, reads XML from a byte-vector or string
;; (<parameter>bv-or-string</parameter>). Delegates to the C function
;; <function>glade_xml_new_from_memory</function>.
(define (glade-xml-new-from-memory bv-or-string . rest)
  (let ((domain (get-keyword #:domain rest))
	(root (get-keyword #:root rest))
	(bv (if (string? bv-or-string)
		(string->bytevector bv-or-string)
		bv-or-string)))
    (wrap-gobject ((foreign-lambda c-pointer "glade_xml_new_from_memory"
				   byte-vector unsigned-int c-string c-string)
		   bv
		   (bytevector-length bv)
		   root
		   domain))))

;;@function (glade-xml-construct xml filename (#:domain domain) (#:root root))
;; Fills in a newly-created GladeXML widget,
;; <parameter>xml</parameter>, with information from the Glade XML
;; file <parameter>filename</parameter>, as for
;; <function>glade-xml-new</function>. Delegates to the C function
;; <function>glade_xml_construct</function>.
(define (glade-xml-construct g filename . rest)
  (let ((domain (get-keyword #:domain rest))
	(root (get-keyword #:root rest)))
    ((foreign-lambda bool "glade_xml_construct" c-pointer c-string c-string c-string)
     (gobject-pointer g)
     filename
     root
     domain)))

(define libglade:handlers #f)
(define-external (libglade_connect_func (c-string handler_name)
					(c-pointer object)
					(c-string signal_name)
					(c-string signal_data)
					(c-pointer connect_object)
					(bool after)
					(c-pointer user_data))
  void
  (cond
   ((assoc handler_name libglade:handlers)
    =>
    (lambda (entry)
      (let ((fn (cadr entry)))
;	(print "Binding " handler_name " <--> " signal_name)
	(gtk-signal-connect (wrap-gobject object) signal_name fn after))))
   (else
    (g-warning "libglade.scm libglade_connect_func: no handler for " handler_name))))

;;@ Connects handlers named in the GladeXML widget
;;<parameter>xml</parameter> to the Scheme functions passed in in
;;<parameter>handlers-alist</parameter>. <parameter>handlers-alist</parameter>
;;should be an association list, suitable for use with
;;<function>assoc</function>, which maps strings (the names of the
;;handlers as specified in the original XML) to Scheme functions of
;;appropriate arity. Delegates to the C function
;;<function>glade_xml_signal_autoconnect_full</function>.
(define (glade-xml-signal-autoconnect xml handlers-alist)
  (set! libglade:handlers handlers-alist)
  ((foreign-callback-lambda* void ((c-pointer pxml))
			     "glade_xml_signal_autoconnect_full("
			     "  pxml,"
			     "  (GladeXMLConnectFunc) libglade_connect_func,"
			     "  NULL"
			     ");")
   (gobject-pointer xml)))

;;@ Retrieve a named subwidget from a GladeXML widget by
;;name. Delegates to the C function
;;<function>glade_xml_get_widget</function>.
(define (glade-xml-get-widget xml name)
  (wrap-gobject ((foreign-lambda c-pointer "glade_xml_get_widget" c-pointer c-string)
		 (gobject-pointer xml)
		 name)))

;;@ Retrieve a named subwidget from a GladeXML widget by long
;;name. Delegates to the C function
;;<function>glade_xml_get_widget_by_long_name</function>.
(define (glade-xml-get-widget-by-long-name xml name)
  (wrap-gobject ((foreign-lambda c-pointer "glade_xml_get_widget_by_long_name" c-pointer c-string)
		 (gobject-pointer xml)
		 name)))
