(require 'g+)

(define (build-gtype-info t)
  (let ((kids (gtype-children t)))
    (cons (gtype-name t)
	  (map build-gtype-info kids))))

(define baseinfo (map build-gtype-info (list gtype:object
					     gtype:interface
					     gtype:boxed
					     gtype:enum
					     gtype:flags)))

(define ts (g+tree-store (list gtype:string)
			 baseinfo))

(define (build-basic-list-mvc coldefs . g+args)
  (let* ((types (map second coldefs))
	 (model (g+list-store types '())))
    (values types
	    model
	    (g+tree-view model
	      g+args
	      (map (lambda (coldef number)
		     (g+tree-view-column (first coldef) 'text number #f #f))
		   coldefs
		   (iota (length coldefs)))))))

(define-values (values-types values-model values-view)
  (build-basic-list-mvc `(("Name" ,gtype:string)
			  ("Value" ,gtype:string))
			(g+property 'search-column 0)))

(define-values (signals-types signals-model signals-view)
  (build-basic-list-mvc `(("Name" ,gtype:string)
			  ("Type" ,gtype:string)
			  ("Return" ,gtype:string)
			  ("Parameters" ,gtype:string))
			(g+property 'rules-hint #t)
			(g+property 'search-column 0)))

(define-values (properties-types properties-model properties-view)
  (build-basic-list-mvc `(("Name" ,gtype:string)
			  ("Type" ,gtype:string)
			  ("Flags" ,gtype:string))
			(g+property 'rules-hint #t)
			(g+property 'search-column 0)))

(define-values (methods-types methods-model methods-view)
  (build-basic-list-mvc `(("Generic function" ,gtype:string)
			  ("Method name" ,gtype:string))
			(g+property 'rules-hint #t)
			(g+property 'search-column 0)))

(define last-object-page 3)

(define explanation-panel
  (begin
    (define (page-for-view l v)
      (g+notebook-page
       (g+label l)
       (g+scrolled-window (null-gobject) (null-gobject)
	 v)))

    (g+notebook
     (g+signal 'switch-page
	       (lambda (nb nbp page-number)
		 (unless (zero? page-number)
		   (set! last-object-page page-number))))
     (page-for-view "_Values" values-view)
     (page-for-view "_Signals" signals-view)
     (page-for-view "_Properties" properties-view)
     (page-for-view "_Methods" methods-view))))

(define describe-type
  (begin
    (define (convert-tinfo entries)
      (map (lambda (entry)
	     (list (symbol->string (first entry))
		   (number->string (third entry))))
	   entries))

    (define (update-values t)
      (cond
       ((gtype-isa? t gtype:enum)
	(g+:list-store-append! values-model
			       values-types
			       (convert-tinfo (genum-info t)))
	#t)
       ((gtype-isa? t gtype:flags)
	(g+:list-store-append! values-model
			       values-types
			       (convert-tinfo (gflags-info t)))
	#t)
       (else #f)))

    (define (update-signals t)
      (g+:list-store-append! signals-model
			     signals-types
			     (map (lambda (siginfo)
				    (list (first siginfo)
					  (gtype-name (second siginfo))
					  (string-append (if (second (fourth siginfo))
							     "(static) "
							     "")
							 (gtype-name (first (fourth siginfo))))
					  (with-output-to-string
					    (lambda ()
					      (display 
					       (map (lambda (t)
						      (if (second t)
							  (list 'static (gtype-name (first t)))
							  (gtype-name (first t))))
						    (fifth siginfo)))))))
				  (if (or (gtype-instantiatable? t)
					  (gtype-interface? t))
				      (gsignal-list-complete t)
				      '()))))

    (define (update-properties t)
      (g+:list-store-append! properties-model
			     properties-types
			     (map (lambda (propinfo)
				    (list (first propinfo)
					  (gtype-name (second propinfo))
					  (with-output-to-string
					    (lambda ()
					      (display (third propinfo))))))
				  (or (and-let* ((p (gobject-class-properties t)))
					(reverse p))
				      '()))))

    (define (update-methods t)
      (g+:list-store-append! methods-model
			     methods-types
			     (map (lambda (method)
				    (list (symbol->string (gobject-method-gf method))
					  (symbol->string (gobject-method-name method))))
				  (gobject:methods-on-class t))))

    (let ((previous-type-name #f))
      (lambda (type-name)
	(if (not (equal? previous-type-name type-name))
	    (let ((t (and type-name (gtype-from-name type-name))))
	      (when t

		(set! previous-type-name type-name)

		(gtk-list-store-clear values-model)
		(gtk-list-store-clear signals-model)
		(gtk-list-store-clear properties-model)
		(gtk-list-store-clear methods-model)

		(if (update-values t)
		    (gtk-notebook-set-current-page explanation-panel 0)
		    (gtk-notebook-set-current-page explanation-panel last-object-page))
		(update-signals t)
		(update-properties t)
		(update-methods t))))))))

(define type-tree
  (g+tree-view ts
    (cut gtk-tree-view-expand-all <>)
    (compose (g+signal 'changed
		       (lambda (sel)
			 (let* ((iter (gtk-tree-iter-new))
				(m (gtk-tree-selection-get-selected sel iter))
				(gv (make-gvalue)))
			   (if m
			       (begin
				 (gtk-tree-model-get-value m iter 0 gv)
				 (describe-type (gvalue->object gv)))
			       (describe-type #f)))))
	     gtk-tree-view-get-selection)
    (g+property 'search-column 0)
    (g+tree-view-column "Name" 'text 0 #f #f)))

(define w (g+window 'toplevel
		    "GType Explorer"
	    (g+signal 'delete_event (lambda _ (gtk-main-quit)))
	    (g+property 'border-width 8)
	    (g+property 'default-width 600)
	    (g+property 'default-height 400)
	    (g+hpaned
	     (g+vbox #f 8
	       (g+pack-start #f #f 0
		 (g+label "_Types:"
		   (g+property 'mnemonic-widget type-tree)
		   (g+property 'xalign 0.0)))
	       (g+scrolled-window (null-gobject) (null-gobject)
		 (g+property 'shadow-type 'etched-in)
		 (g+property 'hscrollbar-policy 'never)
		 (g+property 'vscrollbar-policy 'automatic)
		 type-tree))
	     explanation-panel)))

(gtk-widget-show-all w)
(gtk:gc-idle-timeout 50)
(gtk:gc-when-idle #t)
(gtk-main)
(exit 0)
