#!/opt/chicken/bin/csi -quiet

(require 'g+)

(define tt (g+tooltips))
(letrec ((b2 (g+button "Die"
	       (g+tip tt "This will cause the program to quit")
	       (g+signal 'clicked
			 (lambda (o)
			   (gtk-widget-destroy w)))))
	 (w (g+window 'toplevel
		      "foobar+"
	      (g+property 'height-request 200)
	      (g+signal 'delete_event
			(lambda (o evt)
			  (print o": got delete_event on w: "evt" "(gdk-event-type evt))
			  #t))
	      (g+signal 'destroy
			(lambda (o)
			  (print o": got destroy on w")
			  (gtk-main-quit)))
	      (g+scrolled-window (null-gobject) (null-gobject)
		(cut gtk-scrolled-window-set-policy <> 'never 'automatic)
		(g+vbox #f 4
		  (g+button "Hello, _world!"
		    (g+signal 'clicked
			      (lambda (o)
				(print o": B clicked")))
		    (g+signal 'key_press_event
			      (lambda (o evt)
				(let ((s (gdk-event-string evt)))
				  (if (and (positive? (string-length s))
					   (equal? (string-ref s 0) #\tab))
				      (begin
					(print "Tabbing over")
					(gtk-window-set-focus w b2))
				      (begin
					(print "Got " (gdk-event-type evt))
					(print (gdk-event-string evt)))))
				#t))
		    (g+signal 'enter
			      (lambda (_)
				(print "ENTER")
				(gtk-button-set-label _ "ENTERED")))
		    (g+signal 'leave
			      (lambda (_)
				(print "LEAVE")
				(gtk-button-set-label _ "LEFT")))
		    (g+property 'relief 'none))
		  (g+option-menu
		    (g+menu
		      (g+menu-item "First"
			(g+signal 'activate
				  (lambda (i) (print "Chose 1"))))
		      (g+menu-item*
			(g+button "Hello"
			  (g+signal 'clicked
				    (lambda _ (print "Why, hello!"))))
			(g+menu
			  (g+menu-item "hi1"
			    (g+signal 'activate
				      (lambda (i) (print "Chose 2"))))
			  (g+menu-item "hi2")))
		      (g+menu-item "Third"
			(g+signal 'activate
				  (lambda (i) (print "Chose 3"))))))
		  b2
		  (g+stock-button "gtk-ok"
		    (g+signal 'clicked (lambda (o) (print "Yes!"))))
		  (g+calendar
		    (g+signal 'day-selected
			      (lambda (cal . _)
				(print "SELECTED "cal" "(gtk-calendar-get-date cal))))
		    (g+signal 'day-selected-double-click
			      (lambda (cal . _)
				(print "DCLICK "cal" "(gtk-calendar-get-date cal)))))
		  (g+check-button "Chec_k it"
		    (g+signal 'toggled
			      (lambda (cc)
				(print "Check it: "cc" "(gobject-get-property cc 'active)))))
		  (let ((a (g+adjustment 3 0 6 0.1 0.2 0
			     (g+signal 'value-changed
				       (compose print gtk-adjustment-get-value)))))
		    (list (g+hscrollbar a)
			  (g+hscale a)
			  (g+spin-button a 0.1 1)))
		  (g+arrow 'up 'none)
		  (g+button "Colo_r"
		    (g+signal 'clicked
			      (lambda _ (gtk-widget-show (gtk-color-selection-dialog-new
							  "Choose a silly colour")))))
		  (g+button "My__Fi_le"
		    (g+signal 'clicked
			      (lambda _ (gtk-widget-show (gtk-file-selection-new
							  "Choose a file"))))))))))
  (gtk-widget-show-all w)

  (gtk:gc-when-idle #t)
  (gtk-main))

(exit 0)
