(require 'gtk)

(define (test-gtype)
  (define (expand-gtype t)
    (let ((kids (gtype-children t)))
      (cons* (gtype-name t)
	     (cond
	      ((gtype-isa? t (gtype-from-name "GEnum")) (genum-info t))
	      ((gtype-isa? t (gtype-from-name "GFlags")) (gflags-info t))
	      (else '()))
	     (map expand-gtype kids))))

  (let ((grove (map expand-gtype gtype:fundamental-types)))
    (pretty-print grove)
    (newline))

  (let ((i->n (make-genum-number->nick (gtype-from-name "GdkCursorType")))
	(n->i (make-genum-nick->number (gtype-from-name "GdkCursorType"))))
    (print "GdkCursorType:")
    (print " Value of arrow: " (n->i 'arrow))
    (print " Value of 2: " (i->n 2))
    (newline))

  (let ((f->i (make-gflags->number (gtype-from-name "GdkEventMask"))))
    (print " key-press-mask/key-release-mask (should be 3072): "
	   (f->i '(key-press-mask key-release-mask)))
    (newline))

  (let ((v (make-gvalue (gtype-from-name "GdkCursorType"))))
    (print "Fill returned: " (gvalue-fill! v 'arrow))
    (print "Value from GValue: " (gvalue->object v))
    (newline))

  (let ((l (gobject-class-properties (gtype-from-name "GtkWidget"))))
    (for-each (lambda (ent)
		(set-car! (cdr ent) (gtype-name (cadr ent))))
	      l)
    (pretty-print l)
    (print (gobject-class-find-property (gtype-from-name "GtkWidget") "style"))
    (newline)
    (for-each print (gobject:methods-on-class (gtype-from-name "GtkWidget")))
    (newline)
    (for-each print (gobject:methods-in-gf 'set-title))
    (newline)))

(test-gtype)
(exit 0)
