(require 'g+)

(define ls (g+list-store (list gtype:boolean
			       gtype:uint
			       gtype:string
			       gtype:string)
			 '((#t 123 "hello" "world")
			   (#f 25 "Tony" "Garnock-Jones")
			   (#f 22 "Kali" "Garnock-Jones")
			   (#t 25 "Malcolm" "Chan")
			   (#f 25 "Luke" "Hutchison")
			   (#f 6 "Callum" "Garnock-Jones")
			   (#t 52 "Antona" "Wagstaff"))))
(define fn (g+entry))
(define w (g+window 'toplevel
		    "ChickenListStore demo+"
	    (g+signal 'delete_event (lambda _ (gtk-main-quit)))
	    (g+property 'border-width 8)
	    (g+property 'default-width 280)
	    (g+property 'default-height 250)
	    (g+vbox #f 8
	      (g+pack-start #t #t 0
		(g+scrolled-window (null-gobject) (null-gobject)
		  (g+property 'shadow-type 'etched-in)
		  (g+property 'hscrollbar-policy 'never)
		  (g+property 'vscrollbar-policy 'automatic)
		  (g+tree-view ls
		    (lambda (tv)
		      (gsignal-connect (gtk-tree-view-get-selection tv)
				       'changed
				       (let ((id #f))
					 (lambda (sel)
					   (let* ((iter (gtk-tree-iter-new))
						  (m (gtk-tree-selection-get-selected sel iter))
						  (gv (make-gvalue)))
					     (gtk-tree-model-get-value m
								       iter
								       2
								       gv)
					     (if id
						 (gsignal-disconnect fn id))
					     (gtk-entry-set-text fn (gvalue->object gv))
					     (set! id
						   (gsignal-connect
						    fn
						    'changed
						    (lambda _
						      (gtk-list-store-set-value
						       m
						       iter
						       2
						       (object->gvalue gtype:string
								       (gtk-entry-get-text
									fn)))))))))))
		    (g+property 'rules-hint #t)
		    (g+property 'search-column 3)
		    (g+tree-view-column "Age\neditable?" 'toggle 0
					(lambda (cell path)
					  (let ((iter (gtk-tree-iter-new))
						(v (make-gvalue)))
					    (gtk-tree-model-get-iter-from-string ls iter path)
					    (gtk-tree-model-get-value ls iter 0 v)
					    (gvalue-fill! v (not (gvalue->object v)))
					    (gtk-list-store-set-value ls iter 0 v)))
					#f
		      (g+property 'sizing 'fixed)
		      (g+property 'fixed-width 50))
		    (g+tree-view-column "Age" 'text 1 #f #f
		      (cut gtk-tree-view-column-set-sort-column-id <> 1))
		    (g+tree-view-column "First name" 'text 2
					(lambda (cell path new-text)
					  (let ((iter (gtk-tree-iter-new)))
					    (gtk-tree-model-get-iter-from-string ls iter path)
					    (gtk-list-store-set-value ls iter 2
								      (object->gvalue
								       gtype:string
								       new-text))
					    (gtk-entry-set-text fn new-text)
					    ))
					0
		      (cut gtk-tree-view-column-set-sort-column-id <> 2))
		    (g+tree-view-column "Last name" 'text 3 #f #f))))
	      (g+pack-start #f #f 0
		(g+hbox #f 4
		  (g+label "First name:")
		  fn)))))

(gtk-widget-show-all w)
(gtk:gc-when-idle #t)
(gtk-main)
(exit 0)
