(require 'gtk)

(define (create-model)
  (let ((types (list gtype:boolean
		     gtype:uint
		     gtype:string
		     gtype:string)))
    (define store (apply gtk-list-store-new types))
    (define iter (gtk-tree-iter-new))
    (for-each (lambda (data)
		(gtk-list-store-append store iter)
		(for-each (lambda (i t)
			    (gtk-list-store-set-value store iter i
						      (object->gvalue t
								      (list-ref data i))))
			  (iota (length types))
			  types))
	    '((#t 123 "hello" "world")
	      (#f 25 "Tony" "Garnock-Jones")
	      (#f 22 "Kali" "Garnock-Jones")
	      (#f 22 "Kali" "Garnock-Jones")
	      (#f 22 "Kali" "Garnock-Jones")
	      (#f 22 "Kali" "Garnock-Jones")
	      (#t 25 "Malcolm" "Chan")
	      (#f 25 "Luke" "Hutchison")
	      (#f 6 "Callum" "Garnock-Jones")
	      (#t 52 "Antona" "Wagstaff")))
    store))

(define (add-columns tv model)
  (print 1)
  (let ((r (gtk-cell-renderer-toggle-new))
	(c (gtk-tree-view-column-new)))
    (gtk-signal-connect r 'toggled (lambda (cell path)
				     (print "Path: " path)
				     (let* ((p (gtk-tree-path-new-from-string path))
					    (iter (gtk-tree-iter-new))
					    (v (make-gvalue)))
				       (gtk-tree-model-get-iter model iter p)
				       (gtk-tree-model-get-value model iter 0 v)
				       (gvalue-fill! v (not (gvalue->object v)))
				       (gtk-list-store-set-value model iter 0 v))))
    (gtk-tree-view-column-set-title c "Age\neditable?")
    (gtk-tree-view-column-pack-start c r #t)
    (gtk-tree-view-column-add-attribute c r "active" 0)
    (gtk-tree-view-column-set-sizing c 'fixed)
    (gtk-tree-view-column-set-fixed-width c 50)
    (gtk-tree-view-append-column tv c))
  (print 2)
  (let ((r (gtk-cell-renderer-text-new))
	(c (gtk-tree-view-column-new)))
    (gtk-signal-connect r 'edited (lambda (cell path new-text)
				     (print "Path: " path)
				     (let* ((p (gtk-tree-path-new-from-string path))
					    (iter (gtk-tree-iter-new)))
				       (gtk-tree-model-get-iter model iter p)
				       (and-let* ((n (string->number new-text)))
					 (gtk-list-store-set-value model iter 1
								   (object->gvalue
								    gtype:uint
								    n))))))
    (gtk-tree-view-column-set-title c "Age")
    (gtk-tree-view-column-pack-start c r #t)
    (gtk-tree-view-column-add-attribute c r "text" 1)
    (gtk-tree-view-column-add-attribute c r "editable" 0)
    (gtk-tree-view-column-set-sort-column-id c 1)
    (gtk-tree-view-append-column tv c))
  (print 3)
  (let ((r (gtk-cell-renderer-text-new))
	(c (gtk-tree-view-column-new)))
    (gtk-tree-view-column-set-title c "Severity")
    (gtk-tree-view-column-pack-start c r #t)
    (gtk-tree-view-column-add-attribute c r "text" 2)
    (gtk-tree-view-column-set-sort-column-id c 2)
    (gtk-tree-view-append-column tv c))
  (print 4)
  (let ((r (gtk-cell-renderer-text-new))
	(c (gtk-tree-view-column-new)))
    (gtk-tree-view-column-set-title c "Description")
    (gtk-tree-view-column-pack-start c r #t)
    (gtk-tree-view-column-add-attribute c r "text" 3)
    (gtk-tree-view-column-set-sort-column-id c 3)
    (gtk-tree-view-append-column tv c)))

(define (main)
  (define w (gtk-window-new 'toplevel))
  (define v (gtk-vbox-new #f 8))
  (define sw (gtk-scrolled-window-new (null-gobject) (null-gobject)))
  (define m (create-model))
  (define tv (gtk-tree-view-new-with-model m))

  (gtk-window-set-title w "ChickenListStore demo")

  (gtk-signal-connect w 'delete_event (lambda _ (gtk-main-quit)))

  (gtk-container-set-border-width w 8)

  (gtk-container-add w v)

  (gtk-scrolled-window-set-shadow-type sw 'etched-in)
  (gtk-scrolled-window-set-policy sw 'never 'automatic)
  (gtk-box-pack-start v sw #t #t 0)

  (gtk-tree-view-set-rules-hint tv #t)
  (gtk-tree-view-set-search-column tv 3)

  (gtk-container-add sw tv)

  (add-columns tv m)

  (gtk-window-set-default-size w 280 250)

  (pretty-print (map car (gsignal-list-complete (gobject-type tv))))
  (gtk-signal-connect tv 'cursor-changed (lambda (tv)
					   (let* ((sel (gtk-tree-view-get-selection tv))
						  (iter (gtk-tree-iter-new))
						  (model (gtk-tree-selection-get-selected
							  sel
							  iter))
						  (p (gtk-tree-model-get-path model iter)))
					     (print (gtk-tree-path-to-string p)))))
					     

  (gtk-widget-show-all w)
  (gtk-main))

(main)
(exit 0)
