(require 'g+)

(define ts (g+tree-store (list gtype:string
			       gtype:uint)
			 '(("A" 100
			    ("AA" 110
			     ("AAA" 111))
			    ("AB" 120))
			   ("B" 200
			    ("BA" 210)
			    ("BX" 105)
			    ("BB" 220)))))

(define w (g+window 'toplevel
		    "ChickenTreeStore demo+"
	    (g+signal 'delete_event (lambda _ (gtk-main-quit)))
	    (g+property 'border-width 8)
	    (g+property 'default-width 280)
	    (g+property 'default-height 250)
	    (g+vbox #f 8
	      (g+pack-start #t #t 0
		(g+scrolled-window (null-gobject) (null-gobject)
		  (g+property 'shadow-type 'etched-in)
		  (g+property 'hscrollbar-policy 'never)
		  (g+property 'vscrollbar-policy 'automatic)
		  (g+tree-view ts
		    (compose (g+signal 'changed
				       (lambda (sel)
					 (print "Selection changed: "sel)))
			     gtk-tree-view-get-selection)
		    (g+property 'rules-hint #t)
		    (g+property 'search-column 3)
		    (g+tree-view-column "Name" 'text 0 #f #f)
		    (g+tree-view-column "Number" 'text 1 #f #f
		      (cut gtk-tree-view-column-set-sort-column-id <> 1))
		    ))))))

(gtk-widget-show-all w)
(gtk:gc-when-idle #t)
(gtk-main)
(exit 0)
