/**
 * Copyright (c) 2002 Tony Garnock-Jones
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 **/
#ifndef Chicken_oracleglue_H
#define Chicken_oracleglue_H

enum C_oracleglue_column_kind_t {
  C_ORACLEGLUE_ERROR = -1,
  C_ORACLEGLUE_END_OF_RESULTS = 0,
  C_ORACLEGLUE_COLUMN_NULL,
  C_ORACLEGLUE_COLUMN_INTEGER,
  C_ORACLEGLUE_COLUMN_FLOAT,
  C_ORACLEGLUE_COLUMN_STRING,
  C_ORACLEGLUE_END_OF_ROW
};

extern union C_oracleglue_column_t {
  int i;
  float f;
  struct {
    int len;
    char *ptr;
  } s;
} C_oracleglue_column;

/* 0 --> success, -1 --> fail */
extern int C_oracleglue_setup(void);

/* 0 --> success, -1 --> fail */
extern int C_oracleglue_connect(char *userpass);

extern int C_oracleglue_get_sqlcode(void);
extern char *C_oracleglue_get_error_string(void);

extern char *C_oracleglue_begin_query(char *query);
extern char *C_oracleglue_start_fetch(void);
extern int C_oracleglue_fetch_column(void);
extern int C_oracleglue_end_query(void);

#endif
