(declare
 (uses lolevel srfi-13)

 (export
  md5

  md5-hex-encode

  md5-context?
  md5-init
  md5-update
  md5-final
 )

 (foreign-declare #<<EOF
#include <openssl/md5.h>

#define C_md5_init(bv)		MD5_Init((MD5_CTX *)(bv))
#define C_md5_update(bv,s,l)	MD5_Update((MD5_CTX *)(bv),(s),(l))
#define C_md5_final(s,bv)	MD5_Final((s),(MD5_CTX *)(bv))

EOF
))

(define-foreign-variable md5-context-length int "sizeof(MD5_CTX)")
(define-foreign-variable md5-digest-length int "MD5_DIGEST_LENGTH")

(define-record md5-context bytes)

(define (md5 str . len)
  (let ((result (make-byte-vector md5-digest-length)))
    ((foreign-lambda void "MD5" c-string int byte-vector)
     str
     (if (null? len) (string-length str) (car len))
     result)
    (byte-vector->string result)))

(define md5-hex-encode
  (let ()
    (define (hexdigit n)
      (integer->char
       (if (>= n 10)
	   (+ n -10 (char->integer #\a))
	   (+ n (char->integer #\0)))))
    (lambda (str)
      (let ((result (make-string (* (string-length str) 2)))
	    (i 0))
	(string-for-each (lambda (c)
			   (let ((ch (char->integer c)))
			     (string-set! result i (hexdigit (quotient ch 16)))
			     (string-set! result (+ i 1) (hexdigit (remainder ch 16)))
			     (set! i (+ i 2))))
			 str)
	result))))

(define (md5-init)
  (let ((bv (make-byte-vector md5-context-length)))
    ((foreign-lambda void "C_md5_init" byte-vector) bv)
    (make-md5-context bv)))

(define (md5-update ctxt str . len)
  (if (md5-context? ctxt)
      (let ((bv (md5-context-bytes ctxt)))
	((foreign-lambda void "C_md5_update" byte-vector c-string int)
	 bv
	 str
	 (if (null? len) (string-length str) (car len)))
	#t)
      #f))

(define (md5-final ctxt)
  (if (md5-context? ctxt)
      (let ((result (make-byte-vector md5-digest-length)))
	((foreign-lambda void "C_md5_final" byte-vector byte-vector)
	 result
	 (md5-context-bytes ctxt))
	(byte-vector->string result))
      #f))
