(require 'socket)

(define (assert-equal? a b . description)
  (if (equal? a b)
      (unless (null? description)
	      (print "assert-equal? succeeded " description ": " a))
      (error "assert-equal? failed"
	     (if (null? description) "#<no-description>" description)
	     a
	     b)))

(define (test-basic)
  (let ((af/inet-localhost-12345 (byte-vector
				  #x02 #x00 #x30 #x39
				  #x7f #x00 #x00 #x01
				  #x00 #x00 #x00 #x00
				  #x00 #x00 #x00 #x00)))
    (assert-equal? af/inet-localhost-12345
		   (sockaddr-bytes (name->sockaddr_in 12345 "localhost"))
		   "name->sockaddr_in"))

  (let ((h (socket:gethostbyname "localhost")))
    (assert-equal? (hostent-addr (make-hostent "localhost"
					       '()
					       pf/inet
					       4
					       (list (byte-vector 127 0 0 1))))
		   (hostent-addr h)
		   "gethostbyname" h))

  (print (make-sockaddr_in 12345 (byte-vector 192 168 0 1)))
  (print (make-sockaddr_un "/tmp/my-socket")))

(define (test-conn)
  (process-fork
   (lambda ()
     (thread-sleep! 1)
     (print "CONNECTING TO LOCALHOST:12345...")
     (let ((r (read (car (open-tcp-socket "localhost" 12345 #f)))))
       (print "READ " r))
     (print "DISCONNECTED")
     (exit 0)))
  (print "SERVING")
  (let ((s (make-server-socket (name->sockaddr_in 12345 "localhost")
			       #:reuse? #t)))
    (print "ACCEPTING")
    (let ((f (socket:accept-ports s #f)))
      (print "GOT CONN " f)
      (let ((o (second f)))
	(write `(message ,(+ 1 2) "hello") o)
	(close-output-port o))))
  (thread-sleep! 1)
  (print "test-conn successful"))

(test-basic)
(test-conn)
(exit 0)
