(declare
 (uses posix)
)

(require 'coroutine)

;(set-gc-report! #t)

(define (*test-many-coroutines*)
  (let* ((n 20000)
	 (r 10000)
	 (x (make-vector n)))
    (print "Starting all coroutines...")
    (do ((i 0 (+ i 1)))
	((= i n))
      (when (zero? (remainder i 10000))
	    (print "(starting coroutine "i")"))
      (let ((coro (make-unary-coroutine
		   (lambda (return arg)
		     (let loop ()
		       (let ((msg (return 'dummy)))
			 (when (car msg)
			       (print "Coroutine " i " got message " msg))
			 (loop)))))))
	(vector-set! x i coro)
	(coro 'dummy)))

    (print "Picking threads at random...")
    (do ((i 0 (+ i 1)))
	(#f)
      (let ((t (random n)))
	(let ((report (zero? (remainder i r)))
	      (coro (vector-ref x t)))
	  (coro (list report 'message t i))
	  )))))

(set-signal-handler! signal/int exit)
(*test-many-coroutines*)
(exit 0)
