package G8::Cvs::LocalFile;

use strict;
use diagnostics;
use Carp;

use File::Spec;
use File::Basename;

###########################################################################
# Constructors

sub new($$) {
    my $proto = shift;
    my $class = ref($proto) || $proto;

    my $path = shift;

    my $self = {};
    $self->{PATH} = $path . ",v";
    $self->{TAGS} = {};

    bless($self, $class);
    return $self;
}

###########################################################################
# Member functions

sub readTags($) {
    my $self = shift;

    if (!open(VFILE, "< $self->{PATH}")) {
	my ($name, $dir) = fileparse($self->{PATH});
	my $atticpath = File::Spec->catfile($dir, "Attic", $name);
	if (!open(VFILE, $atticpath)) {
	    carp("Could not open comma-v file $self->{PATH} or $atticpath: $!");
	    return;
	}
    }

    while (defined(my $line = <VFILE>)) {
	$line =~ /^\s+([^:]+):([0-9.]+)(;?)$/ or next;

	my $tag = $1;
	my $version = $2;
	my $semi = $3;

	$self->{TAGS}{$tag} = $version;

	if ($semi) {
	    last;
	}
    }

    close(VFILE);
}

sub branchFor($$) {
    my ($self, $version) = @_;

    my @version = split(/\./, $version);
    my $revision = pop @version;
    my $branch = pop @version;

    $self->readTags;

    my $result = "(trunk)";

    while (my ($tag, $ver) = each %{$self->{TAGS}}) {
	my @ver = split(/\./, $ver);
	my $rev = pop @ver;
	my $br = pop @ver;

	$br == 0 or next;	# Skip non-branch-tags

	if ("@ver" eq "@version" && $rev == $branch) {
	    # We have a match.
#	    print "Matched: $tag, $ver <==> $version\n";
	    $result = $tag;
	}
    }

    return $result;
}

###########################################################################
1;
