package G8::Cvs::Repository;

use strict;
use diagnostics;
use Carp;

use G8::Cvs::LocalFile;
use File::Spec;

###########################################################################
# Constructors

sub _new($) {
    my $proto = shift;
    my $class = ref($proto) || $proto;

    my $self = {};
    $self->{STYLE} = 'UNDEFINED';
    $self->{CACHE_ON} = 1;
    $self->{CACHE} = {};

    bless($self, $class);
    return $self;
}

sub connectLocal {
    my $self = _new(shift);
    my $repodir = shift;

    $self->{STYLE} = 'local';

    $repodir = $ENV{CVSROOT} unless defined $repodir;
    $self->{CVSROOT} = $repodir;

#    print "New Repository object, CVSROOT $repodir.\n";

    return $self;
}

###########################################################################
# Member functions

sub member($$) {
    my $self = shift;
    my $path = shift;

    my $fullpath = File::Spec->catfile($self->{CVSROOT}, $path);

    if (-d $fullpath) {
	carp("CVS doesn't store metainformation about directories ($path)");
	return;
    }

    if ($self->{CACHE_ON}) {
	if (!exists $self->{CACHE}{$path}) {
	    $self->{CACHE}{$path} = G8::Cvs::LocalFile->new($fullpath);
	}
	return $self->{CACHE}{$path};
    } else {
	return G8::Cvs::LocalFile->new($fullpath);
    }
}

sub clearCache($) {
    my $self = shift;
    $self->{CACHE} = {};
}

sub cacheOn($@) {
    my $self = shift;
    my $on = shift;

    $self->{CACHE_ON} = $on if defined $on;
    return $self->{CACHE_ON};
}

###########################################################################
1;
