#!/usr/bin/perl -w

# Runs over all transactions and transaction-entries in the VC
# database, calculating their branch name, and putting that
# information back into the TRANSACTION_ENTRY table.
#
# To be used when you have a database with empty BRANCH columns
# against some or all TRANSACTION_ENTRY rows.
#
# - Tony Garnock-Jones, 5 Feb 2001.

use strict;
use diagnostics;

use DBI;
use G8::Cvs::Repository;

my $repo = G8::Cvs::Repository->connectLocal;
my $dbh = DBI->connect("DBI:mysql:vc") or die("Couldn't connect to VC database!");

###########################################################################

sub updateTransactionEntry($$) {
    my $row = shift;
    my $version = shift;

    my $file = $repo->member($$row{filepath});
    my $tag;

    if (defined $file) {
	$tag = $file->branchFor($version);

	print "$$row{transaction} $$row{filepath}:\n";
	print "\t-version $version\n";
	print "\t-tag     $tag\n";
    } else {
	$tag = "(unknown)";
    }

    my $rv = $dbh->do("update transaction_entry set branch = " . $dbh->quote($tag) . " " .
		      "where transaction = $$row{transaction} " .
		      "and oldversion = " . $dbh->quote($$row{oldversion}) . " " .
		      "and newversion = " . $dbh->quote($$row{newversion}) . " " .
		      "and filepath = " . $dbh->quote($$row{filepath}));

    print $rv ? "Updated OK.\n" : "Update failed!\n";
    print "\n";
}

sub fixupTransactionEntries() {
    my $sth = $dbh->prepare("select transaction, oldversion, newversion, filepath " .
			    "from transaction_entry " .
			    "where branch = ''");

    $sth->execute;
    while (my $row = $sth->fetchrow_hashref) {
	if ($$row{newversion} eq 'NONE') {
	    # File was deleted here. Get the branch from the old version.
	    updateTransactionEntry($row, $$row{oldversion});
	} else {
	    # File was added or modified here. Get the branch from the new version.
	    updateTransactionEntry($row, $$row{newversion});
	}
    }
}

###########################################################################

fixupTransactionEntries();

exit 0;
