/*
 * MySQL database VC, for holding version-control information for change-sets.
 *
 * (C) Tony Garnock-Jones, 2000.
 * Released under the Perl "Artistic" License:
 * http://www.perl.com/language/misc/Artistic.html
 *
 * Transactions are across the entire repository - if you check in across multiple
 * modules in the same repository, it counts as a single transaction.
 */

/* List of "general jobs" - exceptions to the "must-have-bug-number" rule. */
drop table if exists general_jobs;
create table general_jobs (
	jobname varchar(50) not null primary key,
	active bool default 1,
	description varchar(200)
);

/* All transactions recorded by the system. */
drop table if exists transactions;
create table transactions (
	id integer not null auto_increment primary key,
	username varchar(50),
	joblist varchar(200),
	log_message mediumblob,
	mtime timestamp,
	ctime datetime
);

/* Job cross-references. */
drop table if exists job_xref;
create table job_xref (
	job_id varchar(50) not null,
	transaction integer not null references transactions(id),

	index(transaction),
	unique(job_id, transaction)
);

/* Files modified during a CVSzilla transaction. */
drop table if exists transaction_entry;
create table transaction_entry (
	transaction integer not null references transactions(id),
	oldversion varchar(16),
	newversion varchar(16),
	filepath blob not null,
	branch varchar(80) not null default '',

	index(transaction),
	index(transaction, branch)
);

/* Commit-control-lists - user groups */
drop table if exists user_groups;
create table user_groups (
       groupname varchar(50) not null,
       username varchar(50) not null,

       index(groupname),
       index(username)
);

/* Commit-control-lists - open branches */
drop table if exists open_branches;
create table open_branches (
	cvs_module varchar(50) not null,
	branch_name varchar(200),
	groupname varchar(50),
	username varchar(50),

	index(cvs_module)
);

/* Tag logging table */
drop table if exists taglogs;
create table taglogs (
	tag       varchar(50) not null,
	module    varchar(50) not null,
	user      varchar(50) not null,
	tag_date  datetime    not null,

	primary key (tag, module)
);
