# Perl library for VC_VIEW module, for looking at CVSZilla transactions :-)
#
# (C) Tony Garnock-Jones, 2000.
# Released under the Perl "Artistic" License:
# http://www.perl.com/language/misc/Artistic.html
#
# $Id: globals.pl,v 1.16.2.1 2001/09/24 07:22:32 tgarnock-jones Exp $

use Mysql;

###########################################################################

$table_bg = "#eeeeff";

$otable = "<table border=0 cellspacing=4 cellpadding=2 bgcolor=$table_bg width=100%>";
$ofont = "<font face=\"Lucida,Helvetica,Arial\" size=2>";
$cfont = "</font>";

$help_url = "http://www.slashdot.org/";
$bugzilla_path_url = "../bugzilla";
$cvsweb_cgi_url = "../cvsweb/cvsweb.cgi";

my $logo_url = "mozilla-banner.gif";
my $maintainer_email = "root\@localhost";

###########################################################################

sub pageHeader($) {
    my ($title) = @_;

    print <<EOM;
Content-type: text/html

<HTML>
  <HEAD>
    <TITLE>CVSzilla: $title</TITLE>
  </HEAD>
<body bgcolor=black>
<center>
<div align=center>
<table border=0 cellspacing=0 cellpadding=15 width=600 bgcolor=white>
<tr><td align=center>
<img src="$logo_url">
</td></tr>
<tr><td>
$ofont
EOM
}

sub pageFooter() {
    print <<EOM;
<i><div align=right><small>
CVSzilla - <a href="mailto:$maintainer_email">contact the maintainer</a>
</small></div></i>
$cfont
</td></tr>
</table>
</div>
</center>
</body>
</HTML>
EOM
}

sub diePrinting($) {
    ($errorText) = @_;
    print STDERR "$errorText\n";
    print "\n\n$errorText\n";
    exit(1);
}

sub parseQuery() {
    my %dict;

    for (split(/&/, $ENV{"QUERY_STRING"})) {
	my ($key, $value) = split(/=/);
	$value =~ tr/+/ /;
	$value =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
	$dict{$key} = $value;
    }

    return %dict;
}

sub tablerow(@) {
    print "<tr valign=\"top\">";
    for (@_) {
	print "<td>$ofont$_$cfont</td>";
    }
    print "</tr>\n";
}

sub tablerow_x_str(@) {
    my $rowattr = shift;

    if (!$rowattr) {
        $rowattr = "valign=top";
    }

    my $result = "<tr $rowattr>";
    while (@_) {
        my $attr = shift;
        my $content = shift;
        $result .= "<td $attr>$ofont$content$cfont</td>";
    }
    return $result . "</tr>\n";
}

sub tablerow_x(@) {
    print tablerow_x_str(@_);
}

sub formatDate($) {
    my ($str) = @_;
    $str =~ s/\D//g;
    $str =~ s/(....)(..)(..)(..)(..)(..)/$1-$2-$3 $4:$5:$6/;
    return $str;
}

my $toolbar_lhs =
    "<a href=\"transaction.cgi\">CHOOSE&nbsp;TRANSACTION</a> | " .
    "<a href=\"job.cgi\">CHOOSE&nbsp;JOB</a> | " .
    "<a href=\"query.cgi\">QUERY&nbsp;TRANSACTIONS</a> | " .
    "<a href=\"querytag.cgi\">QUERY&nbsp;TAGS</a>";

sub toolbar($) {
    my ($extracell) = @_;

    print "<table border=0 cellspacing=4 cellpadding=2 width=100% bgcolor=$table_bg>\n";
    if ($extracell) {
	tablerow($toolbar_lhs,
		 "<div align=right>$extracell</div>");
    } else {
	tablerow($toolbar_lhs);
    }
    print "</table>\n";
}

sub transactionsTable($$;\&) {
    my ($ids, $longmsg, $filter) = @_;

    tablerow("<b>Transaction ID</b>",
	     "<b>Username</b>",
	     "<b>Created</b>",
	     $longmsg ? "<b>Log entry</b>" : "<b>Partial log entry</b>");

    if (scalar(@{$ids}) == 0) {
	return 0;
    }

    my $query_string = "select id, username, joblist, log_message, ctime " .
	               "from transactions " .
		       "where id in (" .
		       join(",", @{$ids}) .
		       ")";
    my $query = $::db->query($query_string);
#    print "<!-- $query_string -->\n";

    my $count = 0;

    while (my @row = $query->fetchrow()) {
	if (defined $filter && !&$filter(@row)) {
	    next;
	}

	$count++;
	my ($txid, $username, $joblist, $log_message, $ctime) = @row;

	if (!$longmsg && (length($log_message) > 30)) {
	    $log_message = substr($log_message, 0, 27) . "...";
	}

	tablerow("<a href=\"transaction.cgi?id=$txid\">$txid</a>",
		 $username,
		 formatDate($ctime),
		 $log_message ? $log_message : "&nbsp;");
    }

    return $count;
}

###########################################################################

$db = Mysql->Connect("localhost", "vc", "vc", "")
    || diePrinting("Could not connect to VC database");
1;
