#!/usr/bin/perl -w
#
# (C) Tony Garnock-Jones, 2000.
# Released under the Perl "Artistic" License:
# http://www.perl.com/language/misc/Artistic.html
#
# $Id: job.cgi,v 1.16 2001/05/15 22:47:23 tgarnock-jones Exp $

use diagnostics;
use strict;

require "globals.pl";

my @stupid_use_vars_doesnt_work_for_me = ( $::help_url );

###########################################################################

sub greytext($) {
    my $greycolor = '#888888';
    my $txt = shift;
    return "<font color=$greycolor>$txt</font>";
}

sub showJobForm() {
    my $query = $::db->query("select jobname, active, description from general_jobs" .
			     " order by active desc, jobname");
    my @gens;

    while (my @row = $query->fetchrow()) {
	push @gens, \@row;
    }

    toolbar();

    print <<EOM;
<h1>Select a Job ID to list<hr></h1>
<h2>Select a Job Name...</h2>
<table border=0 cellspacing=4 cellpadding=2 bgcolor=$::table_bg>
EOM

    tablerow("<b>Job ID</b>",
	     "<b>Description</b>",
	     "<b>Open?</b>");

    foreach my $row (@gens) {
	my ($jobid, $active, $desc) = @$row;

	if ($active) {
	    tablerow($jobid,
		     $desc,
		     $active ? "Y" : "N");
	} else {
	    tablerow(greytext($jobid),
		     greytext($desc),
		     greytext($active ? "Y" : "N"));
	}
    }

    print <<EOM;

<tr><td colspan=3><i>Please
<a href="$::help_url">click here</a>
for more information about what each General-Job ID is intended to be
used for.</i>
</td></tr>

</table>
<form action="job.cgi" method=GET>
Job ID: <select name="id">
EOM

    foreach my $row (@gens) {
	print "<option>$$row[0]</option>\n";
    }

    print <<EOM;
</select> <input type="submit" value="View Job">
</form>
<h2>...or a Bug Number</h2>
<form action="job.cgi" method=GET>
Bug number: <input type="text" name="id" size="6"> <input type="submit" value="View Bug">
</form>
EOM
}

sub patchLinks(\@$$) {
    my $ids = shift;
    my $dir = shift;
    my $text = shift;

    return "<a href=\"patch.cgi?dir=$dir&id=" . join(",", @{$ids}) . "\">$text</a>";
}

sub printJob($) {
    my ($id) = @_;
    my $title;

    my $query;

    if ($id =~ /^\d+$/) {
	$query = $::db->query("select bug_id from bugs.bugs where bug_id=$id");
	$title = "<a href=\"" . $::bugzilla_path_url . "/show_bug.cgi?id=$id\">bug $id</a>";
    } else {
	$query = $::db->query("select jobname from general_jobs where jobname=" .
			      $::db->quote($id));
	$title = "\"$id\"";
    }

    if (!$query->fetchrow()) {
	print "<h1>Job ID $id Not Found</h1>\n";
	showJobForm();
	return;
    }

    $query = $::db->query("select id " .
			  "from transactions, job_xref " .
			  "where job_id = '$id' and job_xref.transaction = transactions.id");
    my @ids;
    while (my @row = $query->fetchrow) {
	push @ids, $row[0];
    }

    toolbar(patchLinks(@ids, "on", "FORWARD&nbsp;PATCH") . " | " .
	    patchLinks(@ids, "off", "REVERSE&nbsp;PATCH"));

    print <<EOM;
<h1>Transactions against $title</h1>
<table border=0 cellspacing=4 cellpadding=2 bgcolor=$::table_bg>
EOM

    my $count = transactionsTable(\@ids, 0);

    if ($count == 0) {
	tablerow("<i>No transactions have been committed against $title.</i>");
    }

    print <<EOM;
</table>
EOM

    if ($count > 0) {
        print "<p><center><div align=center><i>" .
              "$count transaction(s) found." .
              "</i></div></center></p>\n";
    }
}

###########################################################################

pageHeader("View Job");

my %dict = parseQuery();

if (!defined $dict{"id"} || !$dict{"id"}) {
    showJobForm();
} else {
    printJob($dict{"id"});
}

pageFooter();
exit(0);
