#!/usr/bin/perl -w
#
# (C) Tony Garnock-Jones, 2000.
# Released under the Perl "Artistic" License:
# http://www.perl.com/language/misc/Artistic.html
#
# $Id: patch.cgi,v 1.12 2001/01/28 22:38:09 admin Exp $

use diagnostics;
use strict;

use File::Basename;

require "globals.pl";

my @stupid_use_vars_doesnt_work_for_me = ( $::table_bg, $::ofont, $::cfont );

###########################################################################

my %createdDirs;

sub printAddDirectories($$) {
    my $module = shift;
    my $dir = shift;

    if ($dir ne '.' && !exists $createdDirs{"$module/$dir"}) {
	printAddDirectories($module, dirname($dir));
	print "cvs add $dir\n";
	$createdDirs{"$module/$dir"} = 1;
    }
}

sub maybePrintCreateDir($$) {
    my $module = shift;
    my $dir = shift;

    if (!exists $createdDirs{"$module/$dir"}) {
	print "mkdir -p $dir\n" unless $dir eq '.';
	printAddDirectories($module, $dir);
    }
}

###########################################################################

sub linkTxn($) {
    my $id = shift;
    return "<a href=\"/cvszilla/transaction.cgi?id=$id\">$id</a>";
}

sub secondrow($) {
    my $datum = shift;
    print "<tr><td></td><td colspan=4>$::ofont$datum$::cfont</td></tr>\n";
}

###########################################################################

my $wantdetail = 0;

sub printPatch($$) {
    my ($ids, $fwd) = @_;

    my @ids = split(/,/, $ids);
    if ($fwd) {
	@ids = sort @ids;
    } else {
	@ids = sort {$::b cmp $::a} @ids;
    }
    $ids = join(', ', @ids);

    toolbar("TRANSACTION&nbsp;" . join(", ", map { "<a href=\"transaction.cgi?id=$_\">$_</a>" } @ids));

    my $query = $::db->query("select count(*) from transactions where id in ($ids)");
    my ($rowcount) = $query->fetchrow();
    if ($rowcount != scalar(@ids)) {
	foreach my $id (@ids) {
	    my $query = $::db->query("select id from transactions where id=$id");
	    if (!$query->fetchrow()) {
		print "<h1>Transaction ID $id Not Found</h1>\n";
	    }
	}
	return;
    }

    my $direction = $fwd ? "apply" : "undo";

    print <<EOM;
<h1>Patch to $direction transaction ID(s) $ids</h1>
<p>
Run this snippet of shell script in your \$DEV_TREE directory to
$direction the changes made to the repository for transaction(s) $ids
to your working directory.
</p>

<p>
<h2>Warnings, Error messages, and Notices</h2>
<table border=0 cellspacing=4 cellpadding=2 bgcolor=$::table_bg>
EOM

    tablerow("<i>Txn</i>", "<i>Msg</i>", "<i>Old</i>", "<i>New</i>",
	     "<i>Previous transactions</i>");
    secondrow("<i>Filename</i>");

    my %entries;

    foreach my $id (@ids) {
	$query = $::db->query("select filepath, oldversion, newversion from transaction_entry " .
			      "where transaction = $id order by filepath");
	while (my @row = $query->fetchrow()) {
	    my ($filepath, $oldversion, $newversion) = @row;
	    my ($module, @filecomponents) = split(/\//, $filepath);
	    my $filefragment = join("/", @filecomponents);

	    if (!$fwd) {
		# Switch the order of the operation if we are undoing these transactions.
		my $tmp = $oldversion;
		$oldversion = $newversion;
		$newversion = $tmp;
	    }

	    my $printError = sub ($$) {
		my $msg = shift;
		my $fontcolor = shift;

		$fontcolor = "red" if !defined $fontcolor;

		tablerow(linkTxn($id),
			 "<font color=$fontcolor>$msg</font>",
			 "$entries{$module}{$filefragment}{OLDVERSION} -> " .
			     "$entries{$module}{$filefragment}{NEWVERSION}",
			 "$oldversion -> $newversion",
			 join(', ', map { linkTxn($_) }
			      keys %{$entries{$module}{$filefragment}{TXNS}}));
		secondrow("<font color=$fontcolor>$filefragment</font>");
	    };

	    if (exists $entries{$module}{$filefragment}) {
		# Has been seen before. Keep existing entry.
		if ($oldversion eq 'NONE') {
		    # Hmm! Has been seen before, but we are "creating" the file!
		    $printError->("Attempt to (re)create file!");
		    next;
		}

		if ($oldversion ne $entries{$module}{$filefragment}{NEWVERSION}) {
		    # If this transaction_entry is moving from a different version of
		    # the file than the last one we were dealing with, it's probably
		    # an error. Warn the user.
		    $printError->("Mismatched oldversion/newversion", "#ff8800");
		}

		# Has been seen before, and we are validly upgrading it :-)
		# If they're interested in the details, let them see what numbers we're altering.
		if ($wantdetail) {
		    $printError->("Subsuming versions", "green");
		}
	    } else {
		# Has not been seen before. Remember the first version number we are
		# working from.
		$entries{$module}{$filefragment}{OLDVERSION} = $oldversion;
	    }

	    # Always update the most-recent-version-we-want-to-move-to.
	    $entries{$module}{$filefragment}{NEWVERSION} = $newversion;

	    # Record that this file was modified in this transaction.
	    $entries{$module}{$filefragment}{TXNS}{$id} = 1;
	}
    }

    print <<EOM;
</table>
</p>

<h2>Shell Script</h2>
<table border=0 cellspacing=4 cellpadding=2 bgcolor=$::table_bg width=100%>
<tr><td>
<pre>\#!/bin/sh
\#
\# Automagically-generated patch.
\# Run this in your \$DEV_TREE directory.
\#

EOM

    print "<font color=blue>### Affects modules: " . join(", ", keys %entries) . "</font>\n";

    foreach my $module (keys %entries) {
	print "cd $module\n";

	foreach my $filefragment (keys %{$entries{$module}}) {
	    my $oldversion = $entries{$module}{$filefragment}{OLDVERSION};
	    my $newversion = $entries{$module}{$filefragment}{NEWVERSION};
	    my $filelink = "<a href=\"/cvsweb/index.cgi/$module/$filefragment\">$filefragment</a>";

	    if ($oldversion eq 'NONE') {
		# New file.
		maybePrintCreateDir($module, dirname($filefragment));
		print "cvs update -j $newversion $filelink\n";
	    } elsif ($newversion eq 'NONE') {
		# Removed file.
		print "cvs rm -f $filelink\n";
	    } else {
		# Normal update.
		print "cvs update -j $oldversion -j $newversion $filelink\n";
	    }
	}

	print "cd ..\n";
    }

    print <<EOM;
</pre>
</td></tr>
</table>
EOM
}

###########################################################################

pageHeader("View Patch");

my %dict = parseQuery();

$wantdetail = defined $dict{"detail"};

if (!defined $dict{"id"} || !$dict{"id"} ||
    !defined $dict{"dir"} || !$dict{"dir"}) {
    print "<h1>Invalid arguments</h1>\n";
} else {
    printPatch($dict{"id"}, $dict{"dir"} eq "on");
}

pageFooter();
exit(0);
