#!/usr/bin/perl -w
#
# (C) Tony Garnock-Jones, 2000.
# Released under the Perl "Artistic" License:
# http://www.perl.com/language/misc/Artistic.html
#
# $Id: query.cgi,v 1.8 2001/04/24 00:13:56 tgarnock-jones Exp $

use diagnostics;
use strict;

use Date::Parse;	# for str2time
use Date::Format;	# for time2str

require "globals.pl";

my @stupid_use_vars_doesnt_work_for_me = ( $::db );

###########################################################################

sub queryrow($$) {
    my ($varname, $detail) = @_;

#    tablerow("<select name=\"${varname}_joinstyle\">" .
#	     "<option value=\"R\">Require</option>" .
#	     "<option value=\"A\">Accept</option>" .
#	     "</select>",
#	     $detail);
    tablerow($detail);
}

sub showQueryForm() {
    toolbar();

    print <<EOM;
<form action="query.cgi" method=GET name="queryform">
<input type="hidden" name="mode" value="normal">
<h1>Select transactions where...<hr></h1>
$::otable
EOM

#    tablerow("<b>Constraint</b>",
#	     "<b>Details</b>");

    queryrow("log_substring",
	     "Log message contains " .
	     "<select name=\"log_substring_style\">" .
	     "<option value=\"substring\">the substring</option>" .
	     "<option value=\"allwords\">all the words</option>" .
	     "<option value=\"anywords\">any of the words</option>" .
	     "</select> <input name=\"log_substring\" size=20>");

    queryrow("created",
	     "Transaction created on or after <input name=\"created_after\" size=20>");

    queryrow("username",
	     "Submitting username contains substring <input name=\"username_substring\">");

    queryrow("joblist_kind",
	     "<input type=radio name=joblist_kind value=either checked>Job list can contain general-job IDs mixed freely with bug numbers<br>" .
	     "<input type=radio name=joblist_kind value=general>Job list can contain only general-job IDs<br>" .
	     "<input type=radio name=joblist_kind value=bugs>Job list can contain only bug numbers<br>" .
	     "$::otable<tr><td>$::ofont<input type=radio name=joblist_kind value=specific>Job list contains specific IDs:$::cfont</td><td rowspan=2><input name=\"joblist_ids\"></td></tr>" .
	     "<tr><td>$::ofont<input type=radio name=joblist_kind value=exclude>Job list excludes specific IDs:$::cfont</td></table>");

    queryrow("filepath",
	     "Some file paths " .
	     "<select name=\"filepath_style\">" .
	     "<option value=\"startswith\">start with</option>" .
	     "<option value=\"substring\">contain the substring</option>" .
	     "</select> <input name=\"filepath_substring\">");

    queryrow("branch",
	     "Transaction has " .
	     "<select name=\"branchinclusion_style\">" .
	     "<option value=\"include\">some files</option>" .
	     "<option value=\"exclude\">no files</option>" .
	     "</select> committed against branch <input name=\"branch\">");

    queryrow("longmsg",
	     "<input type=checkbox name=longmsg>Show complete log messages</input>");

    print <<EOM;
</table>
<hr>
<center><div align="center">
<b>(Note: string comparisons are case sensitive)</b>
<br>
<input type="submit" value="Submit Query">
</div></center>
</form>
EOM
}

sub quoteStr($) {
    my ($str) = @_;
    $str =~ s/'/\\'/g;
    return $str;
}

sub listToSet($) {
    my $lst = shift;
    return "(" . join(",", map { "'" . quoteStr($_) . "'" } grep { $_ } split(/[\s,]/, $lst)) . ")";
}

sub patchLinks(\@$$) {
    my $ids = shift;
    my $dir = shift;
    my $text = shift;

    return "<a href=\"patch.cgi?dir=$dir&id=" . join(",", @{$ids}) . "\">$text</a>";
}

sub processQuery(\%) {
    my ($dict) = @_;
    my $filter;

    my $str =
	"select distinct id " .
	"from transactions t, transaction_entry te, job_xref jx " .
	"where (t.id = te.transaction AND t.id = jx.transaction";

    if ($$dict{"log_substring"}) {
	if ($$dict{"log_substring_style"} eq "substring") {
	    $str .= " AND t.log_message like '%" . quoteStr($$dict{"log_substring"}) . "%'";
	} elsif ($$dict{"log_substring_style"} eq "allwords") {
	    foreach my $word (split(/\s/, $$dict{"log_substring"})) {
		$str .= " AND t.log_message like '%" . quoteStr($word) . "%'";
	    }
	} elsif ($$dict{"log_substring_style"} eq "anywords") {
	    my @tests;
	    foreach my $word (split(/\s/, $$dict{"log_substring"})) {
		push @tests, "t.log_message like '%" . quoteStr($word) . "%'";
	    }
	    $str .= " AND (" . join(" OR ", @tests) . ")";
	}
    }

    if ($$dict{"created_after"}) {
	my $date = str2time($$dict{"created_after"});
	if (!defined $date) {
	    print "<h1>Invalid date/time entered.<hr></h1>";
	    return;
	}
	$str .= " AND t.ctime >= " . time2str("'%Y/%m/%d %H:%M:%S'", $date);
    }

    if ($$dict{"username_substring"}) {
	$str .= " AND t.username LIKE '%" . quoteStr($$dict{"username_substring"}) . "%'";
    }

    if ($$dict{"joblist_kind"} eq "general") {
	$filter = sub { $_[2] !~ /\b\d+\b/ };
    } elsif ($$dict{"joblist_kind"} eq "bugs") {
	$filter = sub { $_[2] !~ /[a-zA-Z_]/ };
    } elsif ($$dict{"joblist_kind"} eq "specific" && $$dict{"joblist_ids"}) {
	$str .= " AND jx.job_id in " . listToSet($$dict{"joblist_ids"});
    } elsif ($$dict{"joblist_kind"} eq "exclude") {
	my $want = ($$dict{"joblist_kind"} eq "specific");
	my @ids = grep { $_ } split(/[\s,]/, $$dict{"joblist_ids"});
	$filter = sub {
	    my %jobids = map { $_ => 1 } split(/\s/, $_[2]);
	    if ($want) {
		for (@ids) { return 0 if !defined $jobids{$_}; }
	    } else {
		for (@ids) { return 0 if defined $jobids{$_}; }
	    }
	    return 1;
	};
    }

    if ($$dict{"filepath_substring"}) {
	if ($$dict{"filepath_style"} eq "startswith") {
	    $str .= " AND te.filepath like '" . quoteStr($$dict{"filepath_substring"}) . "%'";
	} elsif ($$dict{"filepath_style"} eq "substring") {
	    $str .= " AND te.filepath like '%" . quoteStr($$dict{"filepath_substring"}) . "%'";
	}
    }

    if ($$dict{"branch"}) {
	if ($$dict{"branchinclusion_style"} eq "exclude") {
#	    $str .= " AND te.branch <> '" . quoteStr($$dict{"branch"}) . "'";
	    $str .= " AND te.branch not in " . listToSet($$dict{"branch"});
	} else {
	    $str .= " AND te.branch in " . listToSet($$dict{"branch"});
	}
    }

    my $longmsg = $$dict{"longmsg"} ? 1 : 0;

    $str .= ")";

    my $query = $::db->query($str);
    my @ids;
    while (my @row = $query->fetchrow) {
	push @ids, $row[0];
    }

    toolbar(patchLinks(@ids, "on", "FORWARD&nbsp;PATCH") . " | " .
	    patchLinks(@ids, "off", "REVERSE&nbsp;PATCH"));

    print <<EOM;
<h1>Query:<hr></h1>
<p>
$str
</p>
<h1>Transactions matching your query:<hr></h1>
$::otable
EOM

    my $count =
	$filter
	    ? transactionsTable(\@ids, $longmsg, $filter)
	    : transactionsTable(\@ids, $longmsg);

    if ($count == 0) {
	tablerow("<i>No transactions matched your query.</i>");
    }

    print <<EOM;
</table>
EOM

    if ($count > 0) {
	print "<p><center><div align=center><i>" .
	      "$count transaction(s) matched." .
	      "</i></div></center></p>\n";
    }
}

###########################################################################

pageHeader("Query Transactions");
my %dict = parseQuery();

if (!defined $dict{"mode"} || !$dict{"mode"}) {
    showQueryForm();
} else {
    processQuery(%dict);
}

pageFooter();
exit(0);
