#!/usr/bin/perl

use DBI;
use CGI qw/:standard/;

sub buildQueryType($$) {
    my ($queryType, $data) = @_;

    if ($queryType eq 'exactly matching') {
	return " lower(tag) = \'$data\' ";

    } elsif ($queryType eq 'containing') {
	return " lower(tag) like \'%$data%\' ";

    } elsif ($queryType eq 'created on or before') {
	return " tag_date <= \'$data\' ";

    } elsif ($queryType eq 'created on or after') {
	return " tag_date >= \'$data\' ";

    }
}

sub buildSortType($) {
    my ($sortType) = @_;

    if ($sortType eq 'tag name') {
	return "order by tag ";

    } elsif ($sortType eq 'by date') {
	return "order by tag_date ";

    }
}

sub buildSortOrder($) {
    my ($sortOrder) = @_;

    if ($sortOrder eq 'ascending') {
	return "asc";

    } elsif ($sortOrder eq 'descending') {
	return "desc";

    }
}

print header,
    start_html('Query CVS Tags'),
    h1('Query CVS Tags'),
    start_form({-METHOD=>GET}),
    "Give me information about tags ",
    popup_menu(-name=>'query-type',
	       -values=>[
			 'exactly matching',
			 'containing',
			 'created on or before',
			 'created on or after'
	       ],
	       -default=>'exactly matching'
	       ),
    textfield('searchData'),
    " sorted by ",
    popup_menu(-name=>'sort-type',
	       -values=>[
			 'tag name',
			 'by date'
	       ],
	       -default=>'tag name'
	       ),
    " in ",
    popup_menu(-name=>'sort-order',
	       -values=>[
			 'ascending',
			 'descending'
	       ],
	       -default=>'ascending'
	       ),
    " order.",
    p,
    submit,
    end_form,
    hr;

if (param()) {
    my $whereClause = "select * from taglogs where ";
    my $queryType = param('query-type');
    my $sortOrder = param('sort-order');
    my $sortType  = param('sort-type');
    my $searchData = param('searchData');

    $whereClause .= buildQueryType($queryType, $searchData);
    $whereClause .= buildSortType($sortType);
    $whereClause .= buildSortOrder($sortOrder);

    my $dbh = DBI->connect("DBI:mysql:vc", "root");

    #print $whereClause, p;

    my $st  = $dbh->prepare($whereClause);

    my $numberRows = $st->execute;
    
    if ($numberRows > 0) {
	my @rows;
	my $currentRow = 1;
	while (@row = $st->fetchrow_array) {
	    $rows[$currentRow] = td(\@row);
	    $currentRow++;
	}
	print table({-border=>1},
		    caption("Tag Information - $numberRows tag" . 
			    ($numberRows == 1 ? "" : "s") .
			    " found."),
		    Tr({},
		       [
			th(['Tag Name', 'CVS Module', 'CVS User', 'Date'])
			]
		       ),
		    Tr({},
		       \@rows
		       )
		    );
    } else {
	print "No tag information availble matching that criteria.";
    }
    $dbh->disconnect;
    hr;
}

