#!/usr/bin/perl -w
#
# $Id: transaction.cgi,v 1.13 2001/06/11 05:28:57 tgarnock-jones Exp $

use diagnostics;
use strict;

require "globals.pl";

my @stupid_use_vars_doesnt_work = ( $::ofont, $::cfont );

###########################################################################

sub showTransactionForm() {
    my $query = $::db->query("select max(id) from transactions");
    my $maxtx = ($query->fetchrow)[0];

    toolbar();

    print <<EOM;
<h1>Enter a Transaction ID to view<hr></h1>
<p>The current maximum transaction ID is $maxtx.</p>
<form action="transaction.cgi" method=GET>
Transaction ID: <input type=text name=id size=10>
</form>
EOM
}

sub linkJobs($) {
    /^\d+$/ || return "<a href=\"job.cgi?id=$_\">$_</a>";

    return
	"<a href=\"$::bugzilla_path_url/show_bug.cgi?id=$_\">bug</a> " .
	"<a href=\"job.cgi?id=$_\">$_</a>";
}

sub linkFile($$) {
    my ($filepath, $filename) = @_;
    return "<a href=\"$::cvsweb_cgi_url/$filepath\">$filename</a>";
}

sub linkVersion($$) {
    my ($filepath, $version) = @_;

    if ($version eq "NONE") {
	return $version;
    } else {
	return
	    "<a href=\"$::cvsweb_cgi_url/$filepath?" .
		"rev=$version&content-type=text/vnd.viewcvs-markup\">$version</a>";
    }
}

sub linkDiff($$$) {
    my ($filepath, $oldversion, $newversion) = @_;

    if ($oldversion eq "NONE" || $newversion eq "NONE") {
	return "";
    } else {
	return
	    "<a href=\"$::cvsweb_cgi_url/$filepath.diff?" .
		"r1=$oldversion&r2=$newversion\">(diffs)</a>";
    }
}

sub linkLogMessage($) {
    my ($msg) = @_;

    my @things;
    my $count = 0;

    # This technique blatantly lifted from Bugzilla proper...

    $msg =~ s/\#/%\#/g;	# because we use ##$count## later.

    # This block of code links up to PyleWikiPages.
    # PyleWiki is available from http://homepages.kcbbs.gen.nz/~tonyg/pyle.html
    #
    while ($msg =~ s/\b([A-Z]+[a-z0-9]+){2,}/"##$count##"/e) {
	my $item = $&;
	if (-e "../pyledb/$item.txt") {
	    $item = qq{<A HREF="/pyle/?arg=$item">$item</A>};
	} else {
	    $item = qq{$item<A HREF="/pyle/?mode=edit&arg=$item">?</A>};
	}
	$things[$count++] = $item;
    }

    # Link up to Bugzilla bugs.
    #
    while ($msg =~ s/\bbug(:|\s|%\#)*(\d+)/"##$count##"/ei) {
	$things[$count++] =
	    qq{<a href="$::bugzilla_path_url/show_bug.cgi?id=$2">$&</a>};
    }

    # Link up to other CVSZilla transactions.
    #
    while ($msg =~ s/\btransaction(:|\s|%\#)*(\d+)/"##$count##"/ei) {
	$things[$count++] =
	    qq{<a href="transaction.cgi?id=$2">$&</a>};
    }

    for (my $i = 0; $i < $count; $i++) {
	$msg =~ s/\#\#$i\#\#/$things[$i]/e;
    }

    $msg =~ s/%\#/\#/g;	# undo quoting. (see above)

    return $msg;
}

sub printTransaction($) {
    my ($id) = @_;

    my $query = $::db->query("select username, joblist, log_message, mtime, ctime " .
			     "from transactions where id=$id");
    my @txn = $query->fetchrow();

    if (!@txn) {
	print "<h1>Transaction ID $id Not Found</h1>\n";
	showTransactionForm();
	return;
    }

    my ($username, $joblist, $log_message, $mtime, $ctime) = @txn;

    $log_message = linkLogMessage($log_message);

    $ctime = formatDate($ctime);
    $mtime = formatDate($mtime);

    toolbar("<a href=\"patch.cgi?dir=on&id=$id\">FORWARD&nbsp;PATCH</a> | " .
	    "<a href=\"patch.cgi?dir=off&id=$id\">REVERSE&nbsp;PATCH</a>");

    print <<EOM;
<form action="transaction.cgi" method="get">
<h1>Transaction ID <input type="text" name="id" value="$id" size=6>
</h1>
</form>
<h2>Details</h2>
$::otable
EOM

    tablerow("Submitting CVS user:", "<b>$username</b>");
    tablerow("Created:", $ctime);
    tablerow("Closed:", $mtime);
    tablerow("Jobs this transaction relates to:",
	     join("; ", map(linkJobs($_), split(/\s/, $joblist))) . "&nbsp;");

    print <<EOM;
</table>
<h2>Log Message</h2>
$::otable
<tr><td>
<pre>$log_message</pre>
</td></tr>
</table>
<h2>Files</h2>
$::otable
EOM

    $query = $::db->query("select filepath, oldversion, newversion, branch " .
			  "from transaction_entry " .
			  "where transaction = $id order by filepath");

    tablerow("<b>Filename</b>",
	     "<b>Old version</b>",
	     "<b>New version (Diffs)</b>",
	     "<b>Branch</b>");

    my $lastpath = "";
    while ((my @row = $query->fetchrow())) {
	my ($filepath, $oldversion, $newversion, $branch) = @row;
	my @filesplit = split(/\//, $filepath);
	my $filename = pop @filesplit;
	my $currpath = join("/", @filesplit);

	if ($currpath ne $lastpath) {
	    print "<tr><td colspan=4>$::ofont<b>Directory:</b> <i>/$currpath</i>$::cfont</td></tr>\n";
	    $lastpath = $currpath;
	}

	tablerow(linkFile($filepath, $filename),
		 linkVersion($filepath, $oldversion),
		 linkVersion($filepath, $newversion) . "&nbsp;" .
		     linkDiff($filepath, $oldversion, $newversion),
		 $branch);
    }

    print <<EOM;
</table>
EOM
}

###########################################################################

pageHeader("View Transaction");

#print "<pre>";
#for (keys %ENV) {
#    print "Key $_\t\t\tValue " . $ENV{$_} . "\n";
#}
#print "</pre>\n";

my %dict = parseQuery();

if (!defined $dict{"id"} || !$dict{"id"}) {
    showTransactionForm();
} else {
    printTransaction($dict{"id"});
}

pageFooter();
exit(0);
